/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.MeteorServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);
    private static final List<String> knownClasses;
    private static final Pattern SERVLET_PATH_PATTERN;

    public static Object readEntirely(AtmosphereResource r) {
        AtmosphereRequest request = r.getRequest();
        return IOUtils.isBodyBinary(request) ? IOUtils.readEntirelyAsByte(r) : (byte[])IOUtils.readEntirelyAsString(r).toString();
    }

    public static final boolean isBodyBinary(AtmosphereRequest request) {
        return request.getContentType() != null && request.getContentType().equalsIgnoreCase("application/octet-stream") || request.getHeader("X-Atmosphere-Binary") != null;
    }

    public static final boolean isBodyEmpty(Object o) {
        return o != null && String.class.isAssignableFrom(o.getClass()) && ((String)String.class.cast(o)).isEmpty() || Byte[].class.isAssignableFrom(o.getClass()) && ((Byte[])Byte[].class.cast(o)).length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder readEntirelyAsString(AtmosphereResource r) {
        StringBuilder stringBuilder = new StringBuilder();
        AtmosphereRequest request = r.getRequest();
        if (request.body().isEmpty()) {
            BufferedReader bufferedReader = null;
            try {
                block21: {
                    try {
                        ServletInputStream inputStream = request.getInputStream();
                        if (inputStream != null) {
                            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                        }
                    }
                    catch (IllegalStateException ex) {
                        logger.trace("", (Throwable)ex);
                        BufferedReader reader = request.getReader();
                        if (reader == null) break block21;
                        bufferedReader = new BufferedReader(reader);
                    }
                }
                if (bufferedReader != null) {
                    char[] charBuffer = new char[8192];
                    int bytesRead = -1;
                    while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                        stringBuilder.append(charBuffer, 0, bytesRead);
                    }
                }
                stringBuilder.append("");
            }
            catch (IOException ex) {
                logger.warn("", (Throwable)ex);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException ex) {
                        logger.warn("", (Throwable)ex);
                    }
                }
            }
        } else {
            AtmosphereRequest.Body body = request.body();
            try {
                stringBuilder.append(body.hasString() ? body.asString() : new String(body.asBytes(), body.byteOffset(), body.byteLength(), request.getCharacterEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                logger.error("", (Throwable)e);
            }
        }
        return stringBuilder;
    }

    public static byte[] readEntirelyAsByte(AtmosphereResource r) {
        AtmosphereRequest request = r.getRequest();
        AtmosphereRequest.Body body = request.body();
        if (body.hasString()) {
            try {
                return IOUtils.readEntirelyAsString(r).toString().getBytes(request.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                logger.error("", (Throwable)e);
            }
        } else if (body.hasBytes()) {
            return Arrays.copyOfRange(body.asBytes(), body.byteOffset(), body.byteLength());
        }
        throw new IllegalStateException("No body " + r);
    }

    public static String guestServletPath(AtmosphereConfig config) {
        String servletPath = "";
        try {
            servletPath = (String)config.getServletContext().getServletRegistration(config.getServletConfig().getServletName()).getMappings().iterator().next();
            servletPath = IOUtils.getCleanedServletPath(servletPath);
        }
        catch (Exception ex) {
            logger.trace("", (Throwable)ex);
        }
        return servletPath;
    }

    public static String getCleanedServletPath(String fullServletPath) {
        Matcher matcher = SERVLET_PATH_PATTERN.matcher(fullServletPath);
        if (!matcher.find()) {
            return fullServletPath;
        }
        String servletPath = matcher.group(0);
        if (!servletPath.startsWith("/")) {
            servletPath = "/" + servletPath;
        }
        return servletPath;
    }

    private static boolean scanForAtmosphereFramework(Class<?> classToScan) {
        if (classToScan == null) {
            return false;
        }
        logger.trace("Scanning {}", (Object)classToScan.getName());
        if (knownClasses.contains(classToScan.getName())) {
            return true;
        }
        try {
            Field[] fields;
            for (Field f : fields = classToScan.getDeclaredFields()) {
                f.setAccessible(true);
                if (!AtmosphereFramework.class.isAssignableFrom(f.getType())) continue;
                return true;
            }
        }
        catch (Exception ex) {
            logger.trace("", (Throwable)ex);
        }
        return IOUtils.scanForAtmosphereFramework(classToScan.getSuperclass());
    }

    public static Class<?> loadClass(Class thisClass, String className) throws Exception {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            return thisClass.getClassLoader().loadClass(className);
        }
    }

    public static boolean isAtmosphere(String className) {
        Class<?> clazz;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            try {
                clazz = IOUtils.class.getClassLoader().loadClass(className);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return AtmosphereServlet.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readServiceFile(String path) {
        ArrayList<String> b = new ArrayList<String>();
        InputStream is = AtmosphereFramework.class.getClassLoader().getResourceAsStream("META-INF/services/" + path);
        if (is == null) {
            return b;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                b.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        return b;
    }

    static {
        SERVLET_PATH_PATTERN = Pattern.compile("([\\/]?[\\w-[.]]+|[\\/]\\*\\*)+");
        knownClasses = new ArrayList<String>(){
            {
                this.add(AtmosphereServlet.class.getName());
                this.add(MeteorServlet.class.getName());
                this.add("com.vaadin.server.VaadinServlet");
                this.add("org.primefaces.push.PushServlet");
            }
        };
    }
}

