/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;

public class CacheHeadersInterceptor
extends AtmosphereInterceptorAdapter {
    private boolean injectCacheHeaders;
    private boolean writeHeaders;

    @Override
    public void configure(AtmosphereConfig config) {
        String nocache = config.getInitParameter(ApplicationConfig.NO_CACHE_HEADERS);
        this.injectCacheHeaders = nocache == null;
        String wh = config.getInitParameter(FrameworkConfig.WRITE_HEADERS);
        this.writeHeaders = wh != null ? Boolean.parseBoolean(wh) : true;
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        AtmosphereResponse response = r.getResponse();
        AtmosphereRequest request = r.getRequest();
        request.setAttribute(ApplicationConfig.NO_CACHE_HEADERS, this.injectCacheHeaders);
        if (this.writeHeaders && this.injectCacheHeaders) {
            response.setHeader("Expires", "-1");
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            response.setHeader("Pragma", "no-cache");
        }
        return Action.CONTINUE;
    }

    public boolean injectCacheHeaders() {
        return this.injectCacheHeaders;
    }

    public boolean writeHeaders() {
        return this.writeHeaders;
    }

    public CacheHeadersInterceptor injectCacheHeaders(boolean injectCacheHeaders) {
        this.injectCacheHeaders = injectCacheHeaders;
        return this;
    }

    public CacheHeadersInterceptor writeHeaders(boolean writeHeaders) {
        this.writeHeaders = writeHeaders;
        return this;
    }

    @Override
    public String toString() {
        return "Default Response's Headers Interceptor";
    }
}

