/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.Future;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBroadcasterProxy
extends DefaultBroadcaster {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBroadcasterProxy.class);
    private Method jerseyBroadcast = null;

    public AbstractBroadcasterProxy() {
        try {
            Class<?> jerseyBroadcasterUtil = Class.forName("org.atmosphere.jersey.util.JerseyBroadcasterUtil");
            this.jerseyBroadcast = jerseyBroadcasterUtil.getMethod("broadcast", AtmosphereResource.class, AtmosphereResourceEvent.class, Broadcaster.class);
        }
        catch (Exception e) {
            logger.trace("", (Throwable)e);
        }
    }

    @Override
    public Broadcaster initialize(String id, URI uri, AtmosphereConfig config) {
        return super.initialize(id, uri, config);
    }

    public abstract void incomingBroadcast();

    public abstract void outgoingBroadcast(Object var1);

    @Override
    protected Runnable getBroadcastHandler() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractBroadcasterProxy.this.incomingBroadcast();
                }
                catch (Throwable t) {
                    logger.warn("incomingBroadcast Exception. Broadcaster will be broken unless reconfigured", t);
                    AbstractBroadcasterProxy.this.destroy();
                    return;
                }
            }
        };
    }

    protected void reconfigure() {
        if (!this.started.get()) {
            return;
        }
        logger.debug("Reconfiguring Broadcaster {}", (Object)this.getID());
        this.spawnReactor();
    }

    @Override
    protected void invokeOnStateChange(AtmosphereResource r, AtmosphereResourceEvent e) {
        if (r.getRequest().getAttribute("org.atmosphere.jersey.containerResponse") != null) {
            try {
                this.jerseyBroadcast.invoke(null, r, e, r.getBroadcaster());
            }
            catch (Throwable t) {
                super.invokeOnStateChange(r, e);
            }
        } else {
            super.invokeOnStateChange(r, e);
        }
    }

    protected void broadcastReceivedMessage(Object message) {
        try {
            Object newMsg = this.filter(message);
            if (newMsg != null) {
                this.push(new Entry(newMsg, new BroadcasterFuture<Object>(newMsg), message));
            }
        }
        catch (Throwable t) {
            logger.error("failed to push message: " + message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Object> broadcast(Object msg) {
        if (this.destroyed.get()) {
            logger.warn("This Broadcaster has been destroyed and cannot be used {}", (Object)this.getID());
            return null;
        }
        this.start();
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        try {
            this.outgoingBroadcast(msg);
        }
        finally {
            this.futureDone(f);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Object> broadcast(Object msg, AtmosphereResource r) {
        if (this.destroyed.get()) {
            logger.warn("This Broadcaster has been destroyed and cannot be used {}", (Object)this.getID());
            return null;
        }
        this.start();
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        try {
            this.outgoingBroadcast(msg);
        }
        finally {
            this.futureDone(f);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Object> broadcast(Object msg, Set<AtmosphereResource> subset) {
        if (this.destroyed.get()) {
            logger.warn("This Broadcaster has been destroyed and cannot be used {}", (Object)this.getID());
            return null;
        }
        this.start();
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        try {
            this.outgoingBroadcast(msg);
        }
        finally {
            this.futureDone(f);
        }
        return f;
    }
}

