/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.interceptor.InvokationOrder;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuspendTrackerInterceptor
extends AtmosphereInterceptorAdapter {
    private final Set<String> trackedUUID = Collections.synchronizedSet(new HashSet());
    private final Logger logger = LoggerFactory.getLogger(SuspendTrackerInterceptor.class);

    @Override
    public Action inspect(final AtmosphereResource r) {
        boolean connecting;
        if (Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        AtmosphereRequest request = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).getRequest(false);
        boolean bl = connecting = request.getHeader("X-Atmosphere-tracking-id") != null && request.getHeader("X-Atmosphere-tracking-id").equals("0");
        if (!connecting && !Utils.pollableTransport(r.transport())) {
            if (!this.trackedUUID.add(r.uuid())) {
                this.logger.trace("Blocking {} from suspend", (Object)r.uuid());
                ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).disableSuspendEvent(true);
            }
            r.addEventListener(new AtmosphereResourceEventListenerAdapter(){

                @Override
                public void onDisconnect(AtmosphereResourceEvent event) {
                    SuspendTrackerInterceptor.this.logger.trace("Untracking {}", (Object)r.uuid());
                    SuspendTrackerInterceptor.this.trackedUUID.remove(r.uuid());
                }

                @Override
                public void onClose(AtmosphereResourceEvent event) {
                    this.onDisconnect(event);
                }
            });
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return "UUID Tracking Interceptor";
    }

    @Override
    public InvokationOrder.PRIORITY priority() {
        return InvokationOrder.BEFORE_DEFAULT;
    }
}

