/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.jboss.servlet.http.HttpEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBossWebCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JBossWebCometSupport.class);
    public static final String HTTP_EVENT = "HttpEvent";
    private static final String SUSPENDED = JBossWebCometSupport.class.getName() + ".suspended";
    private static final IllegalStateException unableToDetectComet = new IllegalStateException(JBossWebCometSupport.unableToDetectComet());
    private final Boolean closeConnectionOnInputStream;

    public JBossWebCometSupport(AtmosphereConfig config) {
        super(config);
        String b = config.getInitParameter("org.atmosphere.container.TomcatCometSupport.discardEOF");
        this.closeConnectionOnInputStream = b == null ? true : Boolean.parseBoolean(b.toString());
        try {
            Class.forName(HttpEvent.class.getName());
        }
        catch (Throwable e) {
            throw new IllegalStateException(JBossWebCometSupport.unableToDetectComet());
        }
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        HttpEvent event = (HttpEvent)req.getAttribute(HTTP_EVENT);
        if (event == null) {
            logger.error("HttpEvent is null, JBoss APR Not Properly installed");
            throw unableToDetectComet;
        }
        logger.trace("Event Type {} for {}", (Object)event.getType(), (Object)req.getQueryString());
        Action action = null;
        AtmosphereResource r = req.resource();
        if (event.getType() == HttpEvent.EventType.BEGIN) {
            action = this.suspended(req, res);
            if (action.type() == Action.TYPE.SUSPEND) {
                try {
                    if (action.timeout() != -1L) {
                        event.setTimeout((int)action.timeout());
                    } else {
                        event.setTimeout(Integer.MAX_VALUE);
                    }
                    req.setAttribute(SUSPENDED, true);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            } else if (action.type() == Action.TYPE.RESUME) {
                event.close();
            } else {
                event.close();
            }
        } else if (event.getType() == HttpEvent.EventType.READ) {
            logger.debug("Receiving bytes, unable to process them.");
        } else if (event.getType() == HttpEvent.EventType.EOF || event.getType() == HttpEvent.EventType.ERROR || event.getType() == HttpEvent.EventType.END) {
            if (r != null && r.isResumed()) {
                ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(req.resource())).cancel();
            } else if (req.getAttribute(SUSPENDED) != null && this.closeConnectionOnInputStream.booleanValue()) {
                req.setAttribute(SUSPENDED, null);
                action = this.cancelled(req, res);
            } else {
                event.close();
            }
        } else if (event.getType() == HttpEvent.EventType.TIMEOUT) {
            action = this.timedout(req, res);
            event.close();
        }
        return action;
    }

    @Override
    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = super.cancelled(req, res);
        if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") != null && (Long)Long.class.cast(req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity")) == -1L) {
            HttpEvent event = (HttpEvent)req.getAttribute(HTTP_EVENT);
            if (event == null) {
                return action;
            }
            event.close();
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        super.action(r);
        if (r.action().type() == Action.TYPE.RESUME && r.isInScope()) {
            this.complete(r);
        }
    }

    @Override
    public AsyncSupport complete(AtmosphereResourceImpl r) {
        try {
            HttpEvent event = (HttpEvent)r.getRequest().getAttribute(HTTP_EVENT);
            if (event != null) {
                event.close();
            }
        }
        catch (IOException ex) {
            logger.debug("", (Throwable)ex);
        }
        return this;
    }

    private static String unableToDetectComet() {
        StringBuilder sb = new StringBuilder();
        sb.append("JBoss failed to detect this is a Comet application because the APR Connector is not enabled. ");
        sb.append("\nMake sure atmosphere-compat-jboss.jar is not under your WEB-INF/lib and ");
        sb.append("You must use the atmosphere-native-runtime dependency in order to use native Comet Support");
        sb.append("\nthere is no context.xml under WEB-INF");
        return sb.toString();
    }
}

