/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import org.atmosphere.container.JBossWebSocketHandler;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBossWebSocketSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JBossWebSocketSupport.class);
    private final HttpEventServlet websocketHandler;

    public JBossWebSocketSupport(AtmosphereConfig config) {
        super(config);
        this.websocketHandler = this.newWebSocketHandler(config);
    }

    private HttpEventServlet newWebSocketHandler(AtmosphereConfig config) {
        try {
            return new JBossWebSocketHandler(config);
        }
        catch (Exception e) {
            logger.error("Cannot instantiate JBossWebSocketHandler. Websocket events will not be handled.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        return this.suspended(req, res);
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    public void dispatch(HttpEvent httpEvent) throws IOException, ServletException {
        if (this.websocketHandler != null) {
            this.websocketHandler.event(httpEvent);
        }
    }
}

