/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.ServletProxyFactory;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereResponse
extends HttpServletResponseWrapper {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereResponse.class);
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, String> headers;
    private AsyncIOWriter asyncIOWriter;
    private int status = 200;
    private String statusMessage = "OK";
    private String charSet = "UTF-8";
    private long contentLength = -1L;
    private String contentType = "text/html";
    private boolean isCommited = false;
    private Locale locale;
    private boolean headerHandled = false;
    private AtmosphereRequest atmosphereRequest;
    private static final HttpServletResponse dsr = (HttpServletResponse)Proxy.newProxyInstance(AtmosphereResponse.class.getClassLoader(), new Class[]{HttpServletResponse.class}, new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return ServletProxyFactory.getDefault().proxy(proxy, method, args);
        }
    });
    private final AtomicBoolean writeStatusAndHeader = new AtomicBoolean(false);
    private boolean delegateToNativeResponse;
    private boolean destroyable;
    private HttpServletResponse response;
    private boolean forceAsyncIOWriter = false;
    private String uuid = "0";
    private final AtomicBoolean usingStream = new AtomicBoolean(true);

    public AtmosphereResponse(AsyncIOWriter asyncIOWriter, AtmosphereRequest atmosphereRequest, boolean destroyable) {
        super(dsr);
        this.response = dsr;
        this.asyncIOWriter = asyncIOWriter;
        this.atmosphereRequest = atmosphereRequest;
        this.writeStatusAndHeader.set(false);
        this.headers = new HashMap<String, String>();
        this.delegateToNativeResponse = asyncIOWriter == null;
        this.destroyable = destroyable;
    }

    public AtmosphereResponse(HttpServletResponse r, AsyncIOWriter asyncIOWriter, AtmosphereRequest atmosphereRequest, boolean destroyable) {
        super(r);
        this.response = r;
        this.asyncIOWriter = asyncIOWriter;
        this.atmosphereRequest = atmosphereRequest;
        this.writeStatusAndHeader.set(false);
        this.headers = new HashMap<String, String>();
        this.delegateToNativeResponse = asyncIOWriter == null;
        this.destroyable = destroyable;
    }

    private AtmosphereResponse(Builder b) {
        super(b.atmosphereResponse);
        this.response = b.atmosphereResponse;
        this.asyncIOWriter = b.asyncIOWriter;
        this.atmosphereRequest = b.atmosphereRequest;
        this.status = b.status;
        this.statusMessage = b.statusMessage;
        this.writeStatusAndHeader.set(b.writeStatusAndHeader.get());
        this.headers = b.headers;
        this.delegateToNativeResponse = this.asyncIOWriter == null;
        this.destroyable = b.destroyable;
    }

    private HttpServletResponse _r() {
        return (HttpServletResponse)HttpServletResponse.class.cast(this.response);
    }

    public void destroy() {
        this.destroy(this.destroyable);
    }

    public void destroy(boolean force) {
        if (!force) {
            return;
        }
        this.cookies.clear();
        this.headers.clear();
        this.atmosphereRequest = null;
        this.asyncIOWriter = null;
    }

    public void addCookie(Cookie cookie) {
        if (this.delegateToNativeResponse) {
            this._r().addCookie(cookie);
        } else {
            this.cookies.add(cookie);
        }
    }

    public boolean containsHeader(String name) {
        return !this.delegateToNativeResponse ? this.headers.get(name) != null : this._r().containsHeader(name);
    }

    public String encodeURL(String url) {
        return this.response.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.response.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.response.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.response.encodeRedirectURL(url);
    }

    public AtmosphereResponse delegateToNativeResponse(boolean delegateToNativeResponse) {
        this.delegateToNativeResponse = delegateToNativeResponse;
        return this;
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.forceAsyncIOWriter || !this.delegateToNativeResponse) {
            this.setStatus(sc, msg);
            boolean b = this.forceAsyncIOWriter;
            this.forceAsyncIOWriter = false;
            this.asyncIOWriter.writeError(this, sc, msg);
            this.forceAsyncIOWriter = b;
        } else if (!this._r().isCommitted()) {
            this._r().sendError(sc, msg);
        } else {
            logger.warn("Committed error code {} {}", (Object)sc, (Object)msg);
        }
    }

    public void sendError(int sc) throws IOException {
        if (this.forceAsyncIOWriter || !this.delegateToNativeResponse) {
            this.setStatus(sc);
            boolean b = this.forceAsyncIOWriter;
            this.forceAsyncIOWriter = false;
            this.asyncIOWriter.writeError(this, sc, "");
            this.forceAsyncIOWriter = b;
        } else if (!this._r().isCommitted()) {
            this._r().sendError(sc);
        } else {
            logger.warn("Committed error code {}", (Object)sc);
        }
    }

    public void sendRedirect(String location) throws IOException {
        if (this.forceAsyncIOWriter || !this.delegateToNativeResponse) {
            boolean b = this.forceAsyncIOWriter;
            this.forceAsyncIOWriter = false;
            this.asyncIOWriter.redirect(this, location);
            this.forceAsyncIOWriter = b;
        } else {
            this._r().sendRedirect(location);
        }
    }

    public void setDateHeader(String name, long date) {
        if (!this.delegateToNativeResponse) {
            this.headers.put(name, String.valueOf(date));
        } else {
            this._r().setDateHeader(name, date);
        }
    }

    public void addDateHeader(String name, long date) {
        if (!this.delegateToNativeResponse) {
            this.headers.put(name, String.valueOf(date));
        } else {
            this._r().setDateHeader(name, date);
        }
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
        if (this.delegateToNativeResponse) {
            this._r().setHeader(name, value);
        }
        if (name.equalsIgnoreCase("X-Atmosphere-tracking-id")) {
            this.uuid = value;
        }
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
        if (this.delegateToNativeResponse) {
            this._r().addHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void setStatus(int status) {
        if (!this.delegateToNativeResponse) {
            this.status = status;
        } else {
            this._r().setStatus(status);
        }
    }

    public void setStatus(int status, String statusMessage) {
        if (!this.delegateToNativeResponse) {
            this.statusMessage = statusMessage;
            this.status = status;
        } else {
            this._r().setStatus(status, statusMessage);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public ServletResponse getResponse() {
        if (Proxy.class.isAssignableFrom(this.response.getClass())) {
            return this;
        }
        return super.getResponse();
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Map<String, String> headers() {
        if (!this.headerHandled) {
            for (Cookie c : this.cookies) {
                this.headers.put("Set-Cookie", c.toString());
            }
            this.headerHandled = true;
        }
        return this.headers;
    }

    public String getHeader(String name) {
        if (name.equalsIgnoreCase("content-type")) {
            String s = this.headers.get("Content-Type");
            return s == null ? this.contentType : s;
        }
        return this.headers.get(name);
    }

    public Collection<String> getHeaders(String name) {
        ArrayList<String> s = new ArrayList<String>();
        String h = name.equalsIgnoreCase("content-type") ? this.headers.get("Content-Type") : this.headers.get(name);
        s.add(h);
        return Collections.unmodifiableList(s);
    }

    public Collection<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    public void setCharacterEncoding(String charSet) {
        if (!this.delegateToNativeResponse) {
            this.charSet = charSet;
        } else {
            this._r().setCharacterEncoding(charSet);
        }
    }

    public void flushBuffer() throws IOException {
        try {
            this.response.flushBuffer();
        }
        catch (IOException ex) {
            this.handleException(ex);
            throw ex;
        }
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public String getCharacterEncoding() {
        if (!this.delegateToNativeResponse) {
            return this.charSet;
        }
        return this._r().getCharacterEncoding() == null ? this.charSet : this._r().getCharacterEncoding();
    }

    public boolean isDestroyable() {
        return this.destroyable;
    }

    public AtmosphereResponse destroyable(boolean destroyable) {
        this.destroyable = destroyable;
        return this;
    }

    private void validAsyncIOWriter() throws IOException {
        if (this.asyncIOWriter == null) {
            throw new IOException("AtmosphereResource Cancelled: " + this.uuid);
        }
    }

    private boolean validFlushOrClose() {
        if (this.asyncIOWriter == null) {
            logger.trace("AtmosphereResponse for {} has been closed", (Object)this.uuid);
            return false;
        }
        return true;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.forceAsyncIOWriter || !this.delegateToNativeResponse) {
            return new ServletOutputStream(){

                public void write(int i) throws IOException {
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    try {
                        AtmosphereResponse.this.validAsyncIOWriter();
                        AtmosphereResponse.this.writeStatusAndHeaders();
                        AtmosphereResponse.this.forceAsyncIOWriter = false;
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, new byte[]{(byte)i});
                    }
                    catch (IOException e) {
                        AtmosphereResponse.this.handleException(e);
                        throw e;
                    }
                    finally {
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                }

                public void write(byte[] bytes) throws IOException {
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    try {
                        AtmosphereResponse.this.validAsyncIOWriter();
                        AtmosphereResponse.this.writeStatusAndHeaders();
                        AtmosphereResponse.this.forceAsyncIOWriter = false;
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, bytes);
                    }
                    catch (IOException e) {
                        AtmosphereResponse.this.handleException(e);
                        throw e;
                    }
                    finally {
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                }

                public void write(byte[] bytes, int start, int offset) throws IOException {
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    try {
                        AtmosphereResponse.this.validAsyncIOWriter();
                        AtmosphereResponse.this.writeStatusAndHeaders();
                        AtmosphereResponse.this.forceAsyncIOWriter = false;
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, bytes, start, offset);
                    }
                    catch (IOException e) {
                        AtmosphereResponse.this.handleException(e);
                        throw e;
                    }
                    finally {
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                }

                public void flush() throws IOException {
                    if (!AtmosphereResponse.this.validFlushOrClose()) {
                        return;
                    }
                    AtmosphereResponse.this.writeStatusAndHeaders();
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    AtmosphereResponse.this.forceAsyncIOWriter = false;
                    try {
                        AtmosphereResponse.this.asyncIOWriter.flush(AtmosphereResponse.this);
                    }
                    catch (IOException e) {
                        AtmosphereResponse.this.handleException(e);
                        throw e;
                    }
                    finally {
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                }

                public void close() throws IOException {
                    if (!AtmosphereResponse.this.validFlushOrClose()) {
                        return;
                    }
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    AtmosphereResponse.this.forceAsyncIOWriter = false;
                    try {
                        AtmosphereResponse.this.asyncIOWriter.close(AtmosphereResponse.this);
                    }
                    catch (IOException e) {
                        AtmosphereResponse.this.handleException(e);
                        throw e;
                    }
                    finally {
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                }
            };
        }
        return this._r().getOutputStream() != null ? this._r().getOutputStream() : new ServletOutputStream(){

            public void write(int b) throws IOException {
            }
        };
    }

    private void writeStatusAndHeaders() throws IOException {
        if (this.writeStatusAndHeader.getAndSet(false) && !this.forceAsyncIOWriter) {
            this.asyncIOWriter.write(this, this.constructStatusAndHeaders());
        }
    }

    private String constructStatusAndHeaders() {
        StringBuffer b = new StringBuffer("HTTP/1.1").append(" ").append(this.status).append(" ").append(this.statusMessage).append("\n");
        b.append("Content-Type").append(":").append(this.headers.get("Content-Type") == null ? this.contentType : this.headers.get("Content-Type")).append("\n");
        if (this.contentLength != -1L) {
            b.append("Content-Length").append(":").append(this.contentLength).append("\n");
        }
        for (String s : this.headers().keySet()) {
            if (s.equalsIgnoreCase("Content-Type")) continue;
            b.append(s).append(":").append(this.headers.get(s)).append("\n");
        }
        b.deleteCharAt(b.length() - 1);
        b.append("\r\n\r\n");
        return b.toString();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.forceAsyncIOWriter || !this.delegateToNativeResponse) {
            return new PrintWriter((OutputStream)this.getOutputStream()){

                @Override
                public void write(char[] chars, int offset, int lenght) {
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    try {
                        AtmosphereResponse.this.validAsyncIOWriter();
                        AtmosphereResponse.this.writeStatusAndHeaders();
                        AtmosphereResponse.this.forceAsyncIOWriter = false;
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, new String(chars, offset, lenght));
                    }
                    catch (IOException e) {
                        AtmosphereResponse.this.handleException(e);
                        throw new RuntimeException(e);
                    }
                    finally {
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                }

                @Override
                public void write(char[] chars) {
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    try {
                        AtmosphereResponse.this.validAsyncIOWriter();
                        AtmosphereResponse.this.writeStatusAndHeaders();
                        AtmosphereResponse.this.forceAsyncIOWriter = false;
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, new String(chars));
                    }
                    catch (IOException e) {
                        AtmosphereResponse.this.handleException(e);
                        throw new RuntimeException(e);
                    }
                    finally {
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                }

                @Override
                public void write(String s, int offset, int lenght) {
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    try {
                        AtmosphereResponse.this.validAsyncIOWriter();
                        AtmosphereResponse.this.writeStatusAndHeaders();
                        AtmosphereResponse.this.forceAsyncIOWriter = false;
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, new String(s.substring(offset, lenght)));
                    }
                    catch (IOException e) {
                        AtmosphereResponse.this.handleException(e);
                        throw new RuntimeException(e);
                    }
                    finally {
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                }

                @Override
                public void write(String s) {
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    try {
                        AtmosphereResponse.this.validAsyncIOWriter();
                        AtmosphereResponse.this.writeStatusAndHeaders();
                        AtmosphereResponse.this.forceAsyncIOWriter = false;
                        AtmosphereResponse.this.asyncIOWriter.write(AtmosphereResponse.this, s);
                    }
                    catch (IOException e) {
                        AtmosphereResponse.this.handleException(e);
                        throw new RuntimeException(e);
                    }
                    finally {
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void flush() {
                    if (!AtmosphereResponse.this.validFlushOrClose()) {
                        return;
                    }
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    try {
                        AtmosphereResponse.this.writeStatusAndHeaders();
                        AtmosphereResponse.this.forceAsyncIOWriter = false;
                        AtmosphereResponse.this.asyncIOWriter.flush(AtmosphereResponse.this);
                    }
                    catch (IOException e) {
                        AtmosphereResponse.this.handleException(e);
                    }
                    finally {
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    if (!AtmosphereResponse.this.validFlushOrClose()) {
                        return;
                    }
                    boolean b = AtmosphereResponse.this.forceAsyncIOWriter;
                    AtmosphereResponse.this.forceAsyncIOWriter = false;
                    try {
                        AtmosphereResponse.this.asyncIOWriter.close(AtmosphereResponse.this);
                    }
                    catch (IOException e) {
                        AtmosphereResponse.this.handleException(e);
                    }
                    finally {
                        AtmosphereResponse.this.forceAsyncIOWriter = b;
                    }
                }
            };
        }
        return this._r().getWriter() != null ? this._r().getWriter() : new PrintWriter(new StringWriter());
    }

    public void setContentLength(int len) {
        this.headers.put("Content-Length", String.valueOf(len));
        if (!this.delegateToNativeResponse) {
            this.contentLength = len;
        } else {
            this._r().setContentLength(len);
        }
    }

    public void setContentType(String contentType) {
        this.headers.put("Content-Type", String.valueOf(contentType));
        if (!this.delegateToNativeResponse) {
            this.contentType = contentType;
        } else {
            this._r().setContentType(contentType);
        }
    }

    public String getContentType() {
        return this.getHeader("Content-type");
    }

    public boolean isCommitted() {
        if (!this.delegateToNativeResponse) {
            return this.isCommited;
        }
        return this._r().isCommitted();
    }

    public void reset() {
        this.response.reset();
    }

    public void resetBuffer() {
        this.response.resetBuffer();
    }

    public void setBufferSize(int size) {
        this.response.setBufferSize(size);
    }

    public void setLocale(Locale locale) {
        if (!this.delegateToNativeResponse) {
            this.locale = locale;
        } else {
            this._r().setLocale(locale);
        }
    }

    public Locale getLocale() {
        if (!this.delegateToNativeResponse) {
            return this.locale;
        }
        return this._r().getLocale();
    }

    public AsyncIOWriter getAsyncIOWriter() {
        return this.asyncIOWriter;
    }

    public AtmosphereResponse asyncIOWriter(AsyncIOWriter asyncIOWriter) {
        this.asyncIOWriter = asyncIOWriter;
        this.forceAsyncIOWriter = true;
        return this;
    }

    public AtmosphereRequest request() {
        return this.atmosphereRequest;
    }

    public AtmosphereResponse request(AtmosphereRequest atmosphereRequest) {
        this.atmosphereRequest = atmosphereRequest;
        return this;
    }

    public void close() throws IOException {
        if (this.asyncIOWriter != null) {
            this.asyncIOWriter.close(this);
        }
    }

    public void closeStreamOrWriter() {
        if (this.resource() != null && this.resource().transport() != AtmosphereResource.TRANSPORT.WEBSOCKET) {
            try {
                if (this.isUsingStream()) {
                    try {
                        this.getOutputStream().close();
                    }
                    catch (IllegalStateException ex) {
                        logger.trace("", (Throwable)ex);
                    }
                } else {
                    this.getWriter().close();
                }
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
        }
    }

    public AtmosphereResponse write(String data) {
        return this.write(data, false);
    }

    private void handleException(Exception ex) {
        AtmosphereResource r = this.resource();
        if (r != null) {
            ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).notifyListeners(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r), true, false));
        }
        logger.debug("", (Throwable)ex);
    }

    public AtmosphereResponse write(String data, boolean writeUsingOriginalResponse) {
        if (Proxy.class.isAssignableFrom(this.response.getClass())) {
            writeUsingOriginalResponse = false;
        }
        try {
            if (this.isUsingStream()) {
                try {
                    ServletOutputStream o = writeUsingOriginalResponse ? this._r().getOutputStream() : this.getOutputStream();
                    o.write(data.getBytes(this.getCharacterEncoding()));
                }
                catch (IllegalStateException ex) {
                    logger.trace("", (Throwable)ex);
                }
            } else {
                PrintWriter w = writeUsingOriginalResponse ? this._r().getWriter() : this.getWriter();
                w.write(data);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return this;
    }

    private boolean isUsingStream() {
        Object s;
        if (this.atmosphereRequest != null && (s = this.atmosphereRequest.getAttribute("org.atmosphere.useStream")) != null) {
            this.usingStream.set((Boolean)s);
        }
        return this.usingStream.get();
    }

    public AtmosphereResponse write(byte[] data) {
        return this.write(data, false);
    }

    public AtmosphereResponse write(byte[] data, boolean writeUsingOriginalResponse) {
        if (data == null) {
            logger.error("Cannot write null value for {}", (Object)this.resource());
            return this;
        }
        if (Proxy.class.isAssignableFrom(this.response.getClass())) {
            writeUsingOriginalResponse = false;
        }
        try {
            if (this.isUsingStream()) {
                try {
                    ServletOutputStream o = writeUsingOriginalResponse ? this._r().getOutputStream() : this.getOutputStream();
                    o.write(data);
                }
                catch (IllegalStateException ex) {}
            } else {
                PrintWriter w = writeUsingOriginalResponse ? this._r().getWriter() : this.getWriter();
                w.write(new String(data, this.getCharacterEncoding()));
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            throw new RuntimeException(ex);
        }
        return this;
    }

    public AtmosphereResponse write(byte[] data, int offset, int length) {
        return this.write(data, offset, length, false);
    }

    public AtmosphereResponse write(byte[] data, int offset, int length, boolean writeUsingOriginalResponse) {
        if (data == null) {
            logger.error("Cannot write null value for {}", (Object)this.resource());
            return this;
        }
        if (Proxy.class.isAssignableFrom(this.response.getClass())) {
            writeUsingOriginalResponse = false;
        }
        try {
            if (this.isUsingStream()) {
                try {
                    ServletOutputStream o = writeUsingOriginalResponse ? this._r().getOutputStream() : this.getOutputStream();
                    o.write(data, offset, length);
                }
                catch (IllegalStateException ex) {}
            } else {
                PrintWriter w = writeUsingOriginalResponse ? this._r().getWriter() : this.getWriter();
                w.write(new String(data, offset, length, this.getCharacterEncoding()));
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return this;
    }

    public AtmosphereResource resource() {
        if (this.atmosphereRequest != null) {
            return (AtmosphereResource)this.atmosphereRequest.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        }
        return null;
    }

    public void setResponse(ServletResponse response) {
        super.setResponse(response);
        if (HttpServletResponse.class.isAssignableFrom(response.getClass())) {
            this.response = (HttpServletResponse)HttpServletResponse.class.cast(response);
        }
    }

    public static final AtmosphereResponse newInstance() {
        return new Builder().build();
    }

    public static final AtmosphereResponse newInstance(AtmosphereConfig config, AtmosphereRequest request, WebSocket webSocket) {
        String s = config.getInitParameter(ApplicationConfig.RECYCLE_ATMOSPHERE_REQUEST_RESPONSE);
        boolean destroyable = s != null && Boolean.valueOf(s) != false;
        return new AtmosphereResponse(webSocket, request, destroyable);
    }

    public static final AtmosphereResponse wrap(HttpServletResponse response) {
        return new Builder().response(response).build();
    }

    public String toString() {
        return "AtmosphereResponse{, uuid=" + this.uuid + ", headers=" + this.headers + ", asyncIOWriter=" + this.asyncIOWriter + ", status=" + this.status + ", statusMessage='" + this.statusMessage + '\'' + ", atmosphereRequest=" + (Object)((Object)this.atmosphereRequest) + ", writeStatusAndHeader=" + this.writeStatusAndHeader + ", delegateToNativeResponse=" + this.delegateToNativeResponse + ", destroyable=" + this.destroyable + ", response=" + this.response + '}';
    }

    static /* synthetic */ HttpServletResponse access$800() {
        return dsr;
    }

    public static final class Builder {
        private AsyncIOWriter asyncIOWriter;
        private int status = 200;
        private String statusMessage = "OK";
        private AtmosphereRequest atmosphereRequest;
        private HttpServletResponse atmosphereResponse = AtmosphereResponse.access$800();
        private AtomicBoolean writeStatusAndHeader = new AtomicBoolean(true);
        private final Map<String, String> headers = new HashMap<String, String>();
        private boolean destroyable = true;

        public Builder destroyable(boolean isRecyclable) {
            this.destroyable = isRecyclable;
            return this;
        }

        public Builder asyncIOWriter(AsyncIOWriter asyncIOWriter) {
            this.asyncIOWriter = asyncIOWriter;
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Builder request(AtmosphereRequest atmosphereRequest) {
            this.atmosphereRequest = atmosphereRequest;
            return this;
        }

        public AtmosphereResponse build() {
            return new AtmosphereResponse(this);
        }

        public Builder header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder writeHeader(boolean writeStatusAndHeader) {
            this.writeStatusAndHeader.set(writeStatusAndHeader);
            return this;
        }

        public Builder response(HttpServletResponse res) {
            this.atmosphereResponse = res;
            return this;
        }
    }
}

