/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util.analytics;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPGetMethod {
    private static final String GET_METHOD_NAME = "GET";
    private static final String SUCCESS_MESSAGE = "JGoogleAnalytics: Tracking Successful!";
    private static String uaName = null;
    private static String osString = "Unknown";
    private final Logger logger = LoggerFactory.getLogger(HTTPGetMethod.class);

    HTTPGetMethod() {
        if (uaName == null) {
            uaName = "Java/" + System.getProperty("java.version");
            osString = System.getProperty("os.arch");
            if (osString == null || osString.length() < 1) {
                osString = "";
            } else {
                osString = osString + "; ";
                osString = osString + System.getProperty("os.name") + " " + System.getProperty("os.version");
            }
        }
    }

    public void request(String urlString) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection urlConnection = this.openURLConnection(url);
            urlConnection.setInstanceFollowRedirects(true);
            urlConnection.setRequestMethod(GET_METHOD_NAME);
            urlConnection.setRequestProperty("User-agent", uaName + " (" + osString + ")");
            urlConnection.connect();
            int responseCode = this.getResponseCode(urlConnection);
            if (responseCode != 200) {
                this.logError("JGoogleAnalytics: Error tracking, url=" + urlString);
            } else {
                this.logMessage(SUCCESS_MESSAGE);
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage());
        }
    }

    protected int getResponseCode(HttpURLConnection urlConnection) throws IOException {
        return urlConnection.getResponseCode();
    }

    private HttpURLConnection openURLConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    private void logMessage(String message) {
        this.logger.trace("{}", (Object)message);
    }

    private void logError(String errorMesssage) {
        this.logger.trace("{}", (Object)errorMesssage);
    }
}

