/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.env.WebEnvironment;
import org.apache.shiro.web.subject.WebSubject;
import org.apache.shiro.web.util.WebUtils;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroInterceptor
implements AtmosphereInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ShiroInterceptor.class);

    @Override
    public void configure(AtmosphereConfig config) {
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (!r.getRequest().attributes().containsKey("subject")) {
            try {
                Subject currentUser = null;
                if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
                    WebEnvironment env = WebUtils.getRequiredWebEnvironment((ServletContext)r.getAtmosphereConfig().getServletContext());
                    currentUser = new WebSubject.Builder(env.getSecurityManager(), (ServletRequest)r.getRequest(), (ServletResponse)r.getResponse()).buildWebSubject();
                } else {
                    currentUser = SecurityUtils.getSubject();
                }
                if (currentUser != null) {
                    r.getRequest().setAttribute("subject", currentUser);
                }
            }
            catch (UnavailableSecurityManagerException ex) {
                logger.info("Shiro Web Security : {}", (Object)ex.getMessage());
            }
            catch (IllegalStateException ex) {
                logger.info("Shiro Web Environment : {}", (Object)ex.getMessage());
            }
        }
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
    }
}

