/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterListenerAdapter;
import org.atmosphere.util.ExecutorsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereResourceStateRecovery
implements AtmosphereInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereResourceStateRecovery.class);
    private final ConcurrentHashMap<String, BroadcasterTracker> states = new ConcurrentHashMap();
    private BroadcasterFactory factory;
    private ScheduledExecutorService stateTracker;
    private long timeout = 300000L;

    @Override
    public void configure(AtmosphereConfig config) {
        this.factory = config.getBroadcasterFactory();
        this.factory.addBroadcasterListener(new B());
        this.stateTracker = ExecutorsFactory.getScheduler(config);
        String s = config.getInitParameter(ApplicationConfig.STATE_RECOVERY_TIMEOUT);
        if (s != null) {
            this.timeout = Long.parseLong(s);
        }
        this.clearStateTracker();
        logger.trace("{} started.", (Object)AtmosphereResourceStateRecovery.class.getName());
    }

    protected void clearStateTracker() {
        this.stateTracker.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                for (Map.Entry t : AtmosphereResourceStateRecovery.this.states.entrySet()) {
                    if (now - ((BroadcasterTracker)t.getValue()).lastTick() <= AtmosphereResourceStateRecovery.this.timeout) continue;
                    logger.trace("AtmosphereResource {} state destroyed.", t.getKey());
                    AtmosphereResourceStateRecovery.this.states.remove(t.getKey());
                }
            }
        }, this.timeout, this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (!r.transport().equals((Object)AtmosphereResource.TRANSPORT.POLLING) && !r.transport().equals((Object)AtmosphereResource.TRANSPORT.AJAX)) {
            Object b;
            BroadcasterTracker tracker = this.track(r).tick();
            List<Object> cachedMessages = new LinkedList<Object>();
            for (String broadcasterID : tracker.ids()) {
                b = this.factory.lookup(broadcasterID, false);
                if (b != null && !b.getID().equalsIgnoreCase(r.getBroadcaster().getID())) {
                    BroadcasterCache cache = b.getBroadcasterConfig().getBroadcasterCache();
                    List<Object> t = cache.retrieveFromCache(b.getID(), r);
                    cachedMessages = b.getBroadcasterConfig().applyFilters(r, cachedMessages);
                    logger.trace("Found Cached Messages For AtmosphereResource {} with Broadcaster {}", (Object)r.uuid(), (Object)broadcasterID);
                    cachedMessages.addAll(t);
                    continue;
                }
                logger.trace("Broadcaster {} is no longer available", (Object)broadcasterID);
            }
            if (cachedMessages.size() > 0) {
                try {
                    r.getAtmosphereHandler().onStateChange(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r), false, false, null).setMessage(cachedMessages));
                }
                catch (IOException e) {
                    logger.warn("Unable to recover from state recovery", (Throwable)e);
                }
                return Action.CANCELLED;
            }
            for (String broadcasterID : tracker.ids()) {
                b = this.factory.lookup(broadcasterID, false);
                if (b != null && !b.getID().equalsIgnoreCase(r.getBroadcaster().getID())) {
                    logger.trace("Associate AtmosphereResource {} with Broadcaster {}", (Object)r.uuid(), (Object)broadcasterID);
                    b.addAtmosphereResource(r);
                    continue;
                }
                logger.trace("Broadcaster {} is no longer available", (Object)broadcasterID);
            }
        }
        return Action.CONTINUE;
    }

    private BroadcasterTracker track(AtmosphereResource r) {
        BroadcasterTracker tracker = this.states.get(r.uuid());
        if (tracker == null) {
            tracker = new BroadcasterTracker();
            this.states.put(r.uuid(), tracker);
            logger.trace("AtmosphereResource {} state now tracked", (Object)r.uuid());
        }
        return tracker;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
    }

    public ConcurrentHashMap<String, BroadcasterTracker> states() {
        return this.states;
    }

    public String toString() {
        return "AtmosphereResource state recovery";
    }

    public static final class BroadcasterTracker {
        private final List<String> broadcasterIds = new LinkedList<String>();
        private long tick = System.currentTimeMillis();

        public BroadcasterTracker add(Broadcaster b) {
            logger.trace("Adding {}", (Object)b.getID());
            if (!this.broadcasterIds.contains(b.getID())) {
                this.broadcasterIds.add(b.getID());
            }
            return this;
        }

        public BroadcasterTracker remove(Broadcaster b) {
            logger.trace("Removing {}", (Object)b.getID());
            this.broadcasterIds.remove(b.getID());
            return this;
        }

        public List<String> ids() {
            return this.broadcasterIds;
        }

        public BroadcasterTracker tick() {
            this.tick = System.currentTimeMillis();
            return this;
        }

        public long lastTick() {
            return this.tick;
        }
    }

    public final class B
    extends BroadcasterListenerAdapter {
        @Override
        public void onAddAtmosphereResource(Broadcaster b, AtmosphereResource r) {
            BroadcasterTracker t = (BroadcasterTracker)AtmosphereResourceStateRecovery.this.states.get(r.uuid());
            if (t == null) {
                t = AtmosphereResourceStateRecovery.this.track(r);
            }
            t.add(b);
        }

        @Override
        public void onRemoveAtmosphereResource(Broadcaster b, AtmosphereResource r) {
            BroadcasterTracker t = (BroadcasterTracker)AtmosphereResourceStateRecovery.this.states.get(r.uuid());
            if (t != null && !r.isCancelled() && !r.isResumed()) {
                t.remove(b);
            } else {
                logger.trace("Keeping the state of {} with broadcaster {}", (Object)r.uuid(), (Object)b.getID());
            }
        }
    }
}

