/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.catalina.websocket.WsOutbound;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;

public class TomcatWebSocket
extends WebSocket {
    private final WsOutbound outbound;

    public TomcatWebSocket(WsOutbound outbound, AtmosphereConfig config) {
        super(config);
        this.outbound = outbound;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public WebSocket write(String s) throws IOException {
        logger.trace("WebSocket.write() for {}", (Object)(this.resource() != null ? this.resource().uuid() : ""));
        this.outbound.writeTextMessage(CharBuffer.wrap(s));
        return this;
    }

    @Override
    public WebSocket write(byte[] b, int offset, int length) throws IOException {
        logger.trace("WebSocket.write() for {}", (Object)(this.resource() != null ? this.resource().uuid() : ""));
        this.outbound.writeBinaryMessage(ByteBuffer.wrap(b, offset, length));
        return this;
    }

    @Override
    public void close() {
        try {
            logger.trace("WebSocket.close() for AtmosphereResource {}", (Object)(this.resource() != null ? this.resource().uuid() : "null"));
            this.outbound.close(1005, ByteBuffer.wrap(new byte[0]));
        }
        catch (IOException e) {
            logger.trace("", (Throwable)e);
        }
    }

    @Override
    public void close(AtmosphereResponse r) throws IOException {
        logger.trace("WebSocket.close()");
        this.outbound.close(1005, ByteBuffer.wrap(new byte[0]));
    }

    @Override
    public WebSocket flush(AtmosphereResponse r) throws IOException {
        this.outbound.flush();
        return this;
    }

    public String toString() {
        return this.outbound.toString();
    }
}

