/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.websocket.WebSocket;

public interface WebSocketEventListener
extends AtmosphereResourceEventListener {
    public void onHandshake(WebSocketEvent var1);

    public void onMessage(WebSocketEvent var1);

    public void onClose(WebSocketEvent var1);

    public void onControl(WebSocketEvent var1);

    public void onDisconnect(WebSocketEvent var1);

    public void onConnect(WebSocketEvent var1);

    public static final class WebSocketEvent<T> {
        private final T message;
        private final TYPE type;
        private final WebSocket webSocket;

        public WebSocketEvent(T message, TYPE type, WebSocket webSocket) {
            this.message = message;
            this.type = type;
            this.webSocket = webSocket;
        }

        public T message() {
            return this.message;
        }

        public WebSocket webSocket() {
            return this.webSocket;
        }

        public TYPE type() {
            return this.type;
        }

        public String toString() {
            return "WebSocketEvent{message='" + this.message + '\'' + ", type=" + (Object)((Object)this.type) + ", webSocket=" + this.webSocket + '}';
        }

        public static enum TYPE {
            CONNECT,
            HANDSHAKE,
            CLOSE,
            MESSAGE,
            CONTROL,
            DISCONNECT,
            STREAM;

        }
    }
}

