/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.cache.CacheMessage;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.util.ExecutorsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBroadcasterCache
implements BroadcasterCache {
    private final Logger logger = LoggerFactory.getLogger(AbstractBroadcasterCache.class);
    protected final List<CacheMessage> messages = new LinkedList<CacheMessage>();
    protected final Set<String> messagesIds = new HashSet<String>();
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected ScheduledFuture scheduledFuture;
    protected long maxCacheTime = TimeUnit.MINUTES.toMillis(2L);
    protected long invalidateCacheInterval = TimeUnit.MINUTES.toMillis(1L);
    protected ScheduledExecutorService reaper = Executors.newSingleThreadScheduledExecutor();
    protected boolean isShared = false;
    protected final List<BroadcasterCacheInspector> inspectors = new LinkedList<BroadcasterCacheInspector>();
    protected final ConcurrentHashMap<String, List<String>> bannedResources = new ConcurrentHashMap();
    protected final List<Object> emptyList = Collections.emptyList();

    @Override
    public void start() {
        this.scheduledFuture = this.reaper.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractBroadcasterCache.this.readWriteLock.writeLock().lock();
                try {
                    long now = System.nanoTime();
                    ArrayList<CacheMessage> expiredMessages = new ArrayList<CacheMessage>();
                    for (CacheMessage message : AbstractBroadcasterCache.this.messages) {
                        if (TimeUnit.NANOSECONDS.toMillis(now - message.getCreateTime()) <= AbstractBroadcasterCache.this.maxCacheTime) continue;
                        expiredMessages.add(message);
                    }
                    for (CacheMessage expiredMessage : expiredMessages) {
                        AbstractBroadcasterCache.this.messages.remove(expiredMessage);
                        AbstractBroadcasterCache.this.messagesIds.remove(expiredMessage.getId());
                    }
                }
                finally {
                    AbstractBroadcasterCache.this.readWriteLock.writeLock().unlock();
                }
            }
        }, 0L, this.invalidateCacheInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
        if (!this.isShared) {
            this.reaper.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheMessage put(BroadcastMessage message, Long now) {
        if (!this.inspect(message)) {
            return null;
        }
        this.logger.trace("Caching message {} for Broadcaster {}", message.message);
        this.readWriteLock.writeLock().lock();
        CacheMessage cacheMessage = null;
        try {
            boolean hasMessageWithSameId = this.messagesIds.contains(message.id);
            if (!hasMessageWithSameId) {
                cacheMessage = new CacheMessage(message.id, now, message.message);
                this.messages.add(cacheMessage);
                this.messagesIds.add(message.id);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return cacheMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Object> get(long cacheHeaderTime) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.readWriteLock.readLock().lock();
        try {
            for (CacheMessage cacheMessage : this.messages) {
                if (cacheMessage.getCreateTime() <= cacheHeaderTime) continue;
                result.add(cacheMessage.getMessage());
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        this.logger.trace("Retrieved messages {}", result);
        return result;
    }

    public AbstractBroadcasterCache setInvalidateCacheInterval(long invalidateCacheInterval) {
        this.invalidateCacheInterval = invalidateCacheInterval;
        return this;
    }

    public AbstractBroadcasterCache setMaxCacheTime(long maxCacheTime) {
        this.maxCacheTime = maxCacheTime;
        return this;
    }

    @Override
    public BroadcasterCache inspector(BroadcasterCacheInspector b) {
        this.inspectors.add(b);
        return this;
    }

    protected boolean inspect(BroadcastMessage m) {
        for (BroadcasterCacheInspector b : this.inspectors) {
            if (b.inspect(m)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void configure(AtmosphereConfig config) {
        Object o = config.properties().get("shared");
        if (o != null) {
            this.isShared = Boolean.parseBoolean(o.toString());
        }
        this.reaper = this.isShared ? ExecutorsFactory.getScheduler(config) : Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public void clearCache(String broadcasterId, AtmosphereResource r, CacheMessage cache) {
        if (cache != null) {
            this.messages.remove(cache);
            this.messagesIds.remove(cache.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void excludeFromCache(String broadcasterId, AtmosphereResource r) {
        AtmosphereResource atmosphereResource = r;
        synchronized (atmosphereResource) {
            List<String> list = this.bannedResources.get(broadcasterId);
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(r.uuid());
            this.bannedResources.put(broadcasterId, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean includeInCache(String broadcasterId, AtmosphereResource r) {
        AtmosphereResource atmosphereResource = r;
        synchronized (atmosphereResource) {
            List<String> list = this.bannedResources.get(broadcasterId);
            if (list != null) {
                return list.remove(r.uuid());
            }
            return false;
        }
    }
}

