/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.CometEvent;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TomcatCometSupport.class);
    public static final String COMET_EVENT = "CometEvent";
    private static final String SUSPENDED = TomcatCometSupport.class.getName() + ".suspended";
    private final Boolean closeConnectionOnInputStream;

    public TomcatCometSupport(AtmosphereConfig config) {
        super(config);
        String b = config.getInitParameter("org.atmosphere.container.TomcatCometSupport.discardEOF");
        this.closeConnectionOnInputStream = b == null ? true : Boolean.parseBoolean(b.toString());
        try {
            Class.forName(CometEvent.class.getName());
        }
        catch (Throwable e) {
            throw new IllegalStateException(TomcatCometSupport.unableToDetectComet());
        }
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        CometEvent event = (CometEvent)req.getAttribute(COMET_EVENT);
        if (event == null) {
            throw new IllegalStateException(TomcatCometSupport.unableToDetectComet());
        }
        Action action = null;
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            action = this.suspended(req, res);
            if (action.type() == Action.TYPE.SUSPEND) {
                try {
                    if (action.timeout() != -1L) {
                        event.setTimeout((int)action.timeout());
                    } else {
                        event.setTimeout(Integer.MAX_VALUE);
                    }
                    req.setAttribute(SUSPENDED, true);
                }
                catch (UnsupportedOperationException ex) {
                    logger.trace("Warning: CometEvent.setTimeout not supported on this Tomcat instance.  [The Tomcat native connector does not support timeouts on asynchronous I/O.]");
                }
                req.setAttribute(SUSPENDED, true);
            } else {
                try {
                    event.close();
                }
                catch (IllegalStateException ex) {
                    logger.trace("event.close", (Throwable)ex);
                }
            }
        } else if (event.getEventType() != CometEvent.EventType.READ) {
            if (event.getEventSubType() == CometEvent.EventSubType.CLIENT_DISCONNECT) {
                if (req.getAttribute(SUSPENDED) != null && this.closeConnectionOnInputStream.booleanValue()) {
                    req.setAttribute(SUSPENDED, null);
                    action = this.cancelled(req, res);
                }
                try {
                    event.close();
                }
                catch (IllegalStateException ex) {
                    logger.trace("event.close", (Throwable)ex);
                }
            } else if (event.getEventSubType() == CometEvent.EventSubType.TIMEOUT) {
                action = this.timedout(req, res);
                try {
                    event.close();
                }
                catch (IllegalStateException ex) {
                    logger.trace("event.close", (Throwable)ex);
                }
            } else if (event.getEventType() == CometEvent.EventType.ERROR) {
                try {
                    event.close();
                }
                catch (IllegalStateException ex) {
                    logger.trace("event.close", (Throwable)ex);
                }
            } else if (event.getEventType() == CometEvent.EventType.END) {
                if (req.resource() != null && req.resource().isResumed()) {
                    ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(req.resource())).cancel();
                } else if (req.getAttribute(SUSPENDED) != null && this.closeConnectionOnInputStream.booleanValue()) {
                    req.setAttribute(SUSPENDED, null);
                    action = this.cancelled(req, res);
                } else {
                    try {
                        event.close();
                    }
                    catch (IllegalStateException ex) {
                        logger.trace("event.close", (Throwable)ex);
                    }
                }
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl resource) {
        super.action(resource);
        if (resource.action().type() == Action.TYPE.RESUME && resource.isInScope()) {
            try {
                CometEvent event = (CometEvent)resource.getRequest().getAttribute(COMET_EVENT);
                if (event == null) {
                    return;
                }
                if (this.config.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive") == null || this.config.getInitParameter("org.atmosphere.cpr.AtmosphereServlet.resumeAndKeepAlive").equalsIgnoreCase("false")) {
                    try {
                        event.close();
                    }
                    catch (IllegalStateException ex) {
                        logger.trace("event.close", (Throwable)ex);
                    }
                }
            }
            catch (IOException ex) {
                logger.debug("action failed", (Throwable)ex);
            }
        }
    }

    @Override
    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = super.cancelled(req, res);
        if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") != null && (Long)Long.class.cast(req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity")) == -1L) {
            CometEvent event = (CometEvent)req.getAttribute(COMET_EVENT);
            if (event == null) {
                return action;
            }
            try {
                event.close();
            }
            catch (IllegalStateException ex) {
                logger.trace("event.close", (Throwable)ex);
            }
        }
        return action;
    }

    private static String unableToDetectComet() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tomcat failed to detect this is a Comet application because context.xml ");
        sb.append("is missing or the Http11NioProtocol Connector is not enabled.");
        sb.append("You must use the AtmosphereCometNativeServlet in order to use native Comet Support");
        sb.append("\nIf that's not the case, you can also remove META-INF/context.xml and WEB-INF/lib/atmosphere-compat-tomcat.jar");
        return sb.toString();
    }
}

