/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import org.atmosphere.cpr.AsyncIOWriterAdapter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.websocket.WebSocketResponseFilter;

public abstract class WebSocket
extends AsyncIOWriterAdapter {
    public static final String WEBSOCKET_INITIATED = WebSocket.class.getName() + ".initiated";
    public static final String WEBSOCKET_SUSPEND = WebSocket.class.getName() + ".suspend";
    public static final String WEBSOCKET_RESUME = WebSocket.class.getName() + ".resume";
    public static final String WEBSOCKET_ACCEPT_DONE = WebSocket.class.getName() + ".acceptDone";
    private AtmosphereResource r;
    protected long lastWrite = 0L;
    protected WebSocketResponseFilter webSocketResponseFilter = WebSocketResponseFilter.NOOPS_WebSocketResponseFilter;
    protected final boolean binaryWrite;
    private final AtmosphereConfig config;

    public WebSocket(AtmosphereConfig config) {
        super(null);
        String s = config.getInitParameter("org.atmosphere.websocket.binaryWrite");
        this.binaryWrite = s != null && Boolean.parseBoolean(s);
        this.config = config;
    }

    public AtmosphereConfig config() {
        return this.config;
    }

    public WebSocket resource(AtmosphereResource r) {
        if (this.r != null && r != null) {
            ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).cloneState(this.r);
        }
        this.r = r;
        return this;
    }

    public AtmosphereResource resource() {
        return this.r;
    }

    public long lastWriteTimeStampInMilliseconds() {
        return this.lastWrite == -1L ? System.currentTimeMillis() : this.lastWrite;
    }

    public WebSocket webSocketResponseFilter(WebSocketResponseFilter w) {
        this.webSocketResponseFilter = w;
        return this;
    }
}

