/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.VoidExecutorService;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebSocketProcessor
implements WebSocketProcessor,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWebSocketProcessor.class);
    private final AtmosphereFramework framework;
    private final WebSocket webSocket;
    private final WebSocketProtocol webSocketProtocol;
    private final AtomicBoolean loggedMsg = new AtomicBoolean(false);
    private final boolean destroyable;
    private final boolean executeAsync;
    private final ExecutorService asyncExecutor;
    private final ExecutorService voidExecutor;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());

    public DefaultWebSocketProcessor(WebSocket webSocket) {
        this.webSocket = webSocket;
        this.framework = webSocket.config().framework();
        this.webSocketProtocol = this.framework.getWebSocketProtocol();
        String s = this.framework.getAtmosphereConfig().getInitParameter(ApplicationConfig.RECYCLE_ATMOSPHERE_REQUEST_RESPONSE);
        this.destroyable = s != null && Boolean.valueOf(s) != false;
        s = this.framework.getAtmosphereConfig().getInitParameter(ApplicationConfig.WEBSOCKET_PROTOCOL_EXECUTION);
        this.executeAsync = s != null && Boolean.valueOf(s) != false;
        this.asyncExecutor = Executors.newCachedThreadPool();
        this.voidExecutor = VoidExecutorService.VOID;
    }

    @Override
    public final void open(AtmosphereRequest request) throws IOException {
        if (!this.loggedMsg.getAndSet(true)) {
            logger.debug("Atmosphere detected WebSocket: {}", (Object)this.webSocket.getClass().getName());
        }
        AtmosphereResponse wsr = new AtmosphereResponse(this.webSocket, request, this.destroyable);
        request.headers(DefaultWebSocketProcessor.configureHeader(request)).setAttribute(WebSocket.WEBSOCKET_SUSPEND, true);
        AtmosphereResource r = AtmosphereResourceFactory.getDefault().create(this.framework.getAtmosphereConfig(), wsr, this.framework.getAsyncSupport());
        request.setAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE, r);
        request.setAttribute(ApplicationConfig.SUSPENDED_ATMOSPHERE_RESOURCE_UUID, r.uuid());
        this.webSocket.resource(r);
        this.webSocketProtocol.onOpen(this.webSocket);
        this.dispatch(request, wsr);
        request.removeAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE);
        if (this.webSocket.resource() != null) {
            final AsynchronousProcessor.AsynchronousProcessorHook hook = new AsynchronousProcessor.AsynchronousProcessorHook((AtmosphereResourceImpl)this.webSocket.resource());
            request.setAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK, hook);
            final Action action = ((AtmosphereResourceImpl)this.webSocket.resource()).action();
            if (action.timeout() != -1L && !this.framework.getAsyncSupport().getContainerName().contains("Netty")) {
                final AtomicReference f = new AtomicReference();
                f.set(this.scheduler.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        if (WebSocket.class.isAssignableFrom(DefaultWebSocketProcessor.this.webSocket.getClass()) && System.currentTimeMillis() - ((WebSocket)WebSocket.class.cast(DefaultWebSocketProcessor.this.webSocket)).lastWriteTimeStampInMilliseconds() > action.timeout()) {
                            hook.timedOut();
                            ((Future)f.get()).cancel(true);
                        }
                    }
                }, action.timeout(), action.timeout(), TimeUnit.MILLISECONDS));
            }
        } else {
            logger.warn("AtmosphereResource was null");
        }
        this.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.CONNECT, this.webSocket));
    }

    @Override
    public void invokeWebSocketProtocol(String webSocketMessage) {
        List<AtmosphereRequest> list = this.webSocketProtocol.onMessage(this.webSocket, webSocketMessage);
        this.dispatch(list);
        this.notifyListener(new WebSocketEventListener.WebSocketEvent(webSocketMessage, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocket));
    }

    private void dispatch(List<AtmosphereRequest> list) {
        if (list == null) {
            return;
        }
        for (final AtmosphereRequest r : list) {
            if (r == null) continue;
            boolean b = r.dispatchRequestAsynchronously();
            ExecutorService s = this.executeAsync || b ? this.asyncExecutor : this.voidExecutor;
            s.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtmosphereResponse w = new AtmosphereResponse(DefaultWebSocketProcessor.this.webSocket, r, DefaultWebSocketProcessor.this.destroyable);
                    try {
                        DefaultWebSocketProcessor.this.dispatch(r, w);
                    }
                    finally {
                        r.destroy();
                        w.destroy();
                    }
                }
            });
        }
    }

    @Override
    public void invokeWebSocketProtocol(byte[] data, int offset, int length) {
        List<AtmosphereRequest> list = this.webSocketProtocol.onMessage(this.webSocket, data, offset, length);
        this.dispatch(list);
        try {
            this.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocket));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
    }

    public final void dispatch(AtmosphereRequest request, AtmosphereResponse r) {
        if (request == null) {
            return;
        }
        try {
            this.framework.doCometSupport(request, r);
        }
        catch (Throwable e) {
            logger.warn("Failed invoking AtmosphereFramework.doCometSupport()", e);
            this.webSocketProtocol.onError(this.webSocket, new WebSocketProcessor.WebSocketException(e, new AtmosphereResponse.Builder().request(request).status(500).statusMessage("Server Error").build()));
            return;
        }
        if (r.getStatus() >= 400) {
            this.webSocketProtocol.onError(this.webSocket, new WebSocketProcessor.WebSocketException("Status code higher or equal than 400", r));
        }
    }

    @Override
    public WebSocket webSocket() {
        return this.webSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int closeCode) {
        block14: {
            logger.trace("WebSocket closed with {}", (Object)closeCode);
            this.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.CLOSE, this.webSocket));
            AtmosphereResourceImpl resource = (AtmosphereResourceImpl)this.webSocket.resource();
            if (resource == null) {
                logger.warn("Unable to retrieve AtmosphereResource for {}", (Object)this.webSocket);
            } else {
                AtmosphereRequest r = resource.getRequest(false);
                AtmosphereResponse s = resource.getResponse(false);
                try {
                    this.webSocketProtocol.onClose(this.webSocket);
                    if (resource == null || !resource.isInScope()) break block14;
                    AsynchronousProcessor.AsynchronousProcessorHook h = (AsynchronousProcessor.AsynchronousProcessorHook)r.getAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK);
                    if (h != null) {
                        if (closeCode == 1000) {
                            h.timedOut();
                        } else {
                            h.closed();
                        }
                    } else {
                        logger.warn("AsynchronousProcessor.AsynchronousProcessorHook was null");
                    }
                    resource.setIsInScope(false);
                    try {
                        resource.cancel();
                    }
                    catch (IOException e) {
                        logger.trace("", (Throwable)e);
                    }
                    AsynchronousProcessor.destroyResource(resource);
                }
                finally {
                    if (r != null) {
                        r.destroy(true);
                    }
                    if (s != null) {
                        s.destroy(true);
                    }
                    if (this.webSocket != null) {
                        this.webSocket.resource(null);
                    }
                }
            }
        }
        this.asyncExecutor.shutdown();
        this.voidExecutor.shutdown();
        this.scheduler.shutdown();
    }

    public String toString() {
        return "DefaultWebSocketProtocol{ webSocket=" + this.webSocket + " }";
    }

    @Override
    public void notifyListener(WebSocketEventListener.WebSocketEvent event) {
        AtmosphereResource resource = this.webSocket.resource();
        if (resource == null) {
            return;
        }
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(resource);
        for (AtmosphereResourceEventListener l : r.atmosphereResourceEventListener()) {
            if (!WebSocketEventListener.class.isAssignableFrom(l.getClass())) continue;
            try {
                switch (event.type()) {
                    case CONNECT: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onConnect(event);
                        break;
                    }
                    case DISCONNECT: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onDisconnect(event);
                        break;
                    }
                    case CONTROL: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onControl(event);
                        break;
                    }
                    case MESSAGE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onMessage(event);
                        break;
                    }
                    case HANDSHAKE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onHandshake(event);
                        break;
                    }
                    case CLOSE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onDisconnect(event);
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onClose(event);
                    }
                }
            }
            catch (Throwable t) {
                logger.debug("Listener error {}", t);
                try {
                    ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onThrowable(new AtmosphereResourceEventImpl(r, false, false, t));
                }
                catch (Throwable t2) {
                    logger.warn("Listener error {}", t2);
                }
            }
        }
    }

    public static final Map<String, String> configureHeader(AtmosphereRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration<String> e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            headers.put(s, request.getParameter(s));
        }
        headers.put("X-Atmosphere-Transport", "websocket");
        return headers;
    }
}

