/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.DefaultWebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.atmosphere.container.GlassFishWebSocketSupport;
import org.atmosphere.container.version.GrizzlyWebSocket;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.util.DefaultEndpointMapper;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlassFishWebSocketHandler
extends WebSocketApplication {
    private static final Logger logger = LoggerFactory.getLogger(GlassFishWebSocketSupport.class);
    private final AtmosphereConfig config;
    private final HashMap<String, Boolean> paths = new HashMap();
    private final WebSocketProcessor webSocketProcessor;
    private final ConcurrentHashMap<com.sun.grizzly.websockets.WebSocket, WebSocket> wMap = new ConcurrentHashMap();
    private final EndpointMapper<Boolean> mapper = new DefaultEndpointMapper<Boolean>();

    public GlassFishWebSocketHandler(AtmosphereConfig config) {
        this.config = config;
        this.paths(config.getServletContext());
        this.webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(config.framework());
    }

    void paths(ServletContext sc) {
        Map m = this.config.getServletContext().getServletRegistrations();
        ServletRegistration sr = (ServletRegistration)m.get(this.config.getServletConfig().getServletName());
        if (sr != null) {
            for (String mapping : sr.getMappings()) {
                if (mapping.contains("*")) {
                    mapping = mapping.replace("*", "[a-zA-Z0-9-&.*_~=@;\\?]+");
                }
                if (mapping.endsWith("/")) {
                    mapping = mapping + "[a-zA-Z0-9-&.*_~=@;\\?]+";
                }
                this.paths.put(mapping, Boolean.TRUE);
            }
        }
    }

    public void onConnect(com.sun.grizzly.websockets.WebSocket w) {
        super.onConnect(w);
        GrizzlyWebSocket webSocket = new GrizzlyWebSocket(w, this.config);
        if (!DefaultWebSocket.class.isAssignableFrom(w.getClass())) {
            throw new IllegalStateException();
        }
        DefaultWebSocket dws = (DefaultWebSocket)DefaultWebSocket.class.cast(w);
        this.wMap.put(w, webSocket);
        try {
            AtmosphereRequest r = AtmosphereRequest.wrap(dws.getRequest());
            try {
                if (r.getPathInfo() == null) {
                    String uri = r.getRequestURI();
                    String pathInfo = uri.substring(uri.indexOf(r.getServletPath()) + r.getServletPath().length());
                    r.pathInfo(pathInfo);
                }
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            this.webSocketProcessor.open(webSocket, r);
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    public boolean isApplicationRequest(Request request) {
        if (!request.requestURI().startsWith(this.config.getServletContext().getContextPath())) {
            return false;
        }
        String path = request.requestURI().toString().substring(this.config.getServletContext().getContextPath().length());
        Boolean b = this.mapper.map(path, this.paths);
        return b == null ? false : b;
    }

    public void onClose(com.sun.grizzly.websockets.WebSocket w, DataFrame df) {
        super.onClose(w, df);
        logger.trace("onClose {} ", (Object)w);
        if (this.webSocketProcessor != null) {
            this.webSocketProcessor.close(this.wMap.remove(w), 1005);
        }
    }

    public void onMessage(com.sun.grizzly.websockets.WebSocket w, String text) {
        logger.trace("onMessage {} ", (Object)w);
        if (this.webSocketProcessor != null) {
            this.webSocketProcessor.invokeWebSocketProtocol(this.w(w), text);
        }
    }

    public void onMessage(com.sun.grizzly.websockets.WebSocket w, byte[] bytes) {
        logger.trace("onMessage (bytes) {} ", (Object)w);
        if (this.webSocketProcessor != null) {
            this.webSocketProcessor.invokeWebSocketProtocol(this.w(w), bytes, 0, bytes.length);
        }
    }

    public void onPing(com.sun.grizzly.websockets.WebSocket w, byte[] bytes) {
        logger.trace("onPing (bytes) {} ", (Object)w);
    }

    public void onPong(com.sun.grizzly.websockets.WebSocket w, byte[] bytes) {
        logger.trace("onPong (bytes) {} ", (Object)w);
    }

    public void onFragment(com.sun.grizzly.websockets.WebSocket w, byte[] bytes, boolean last) {
        logger.trace("onFragment (bytes) {} ", (Object)w);
    }

    public void onFragment(com.sun.grizzly.websockets.WebSocket w, String text, boolean last) {
        logger.trace("onFragment (string) {} ", (Object)w);
    }

    WebSocket w(com.sun.grizzly.websockets.WebSocket w) {
        return this.wMap.get(w);
    }
}

