/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongPollingOnOpenInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(LongPollingOnOpenInterceptor.class);
    private static final byte[] padding;
    private static final String paddingText;

    @Override
    public void configure(AtmosphereConfig config) {
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        AtmosphereResponse response = r.getResponse();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.LONG_POLLING) || r.transport().equals((Object)AtmosphereResource.TRANSPORT.JSONP)) {
            response.write(padding, true);
            try {
                response.flushBuffer();
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return "Long-Polling Padding Interceptor Support";
    }

    static {
        StringBuilder whitespace = new StringBuilder();
        for (int i = 0; i < 8192; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
        paddingText = whitespace.toString();
        padding = paddingText.getBytes();
    }
}

