/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.websocket.WsOutbound;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatWebSocket
extends WebSocket {
    private final WsOutbound outbound;
    private static final Logger logger = LoggerFactory.getLogger(TomcatWebSocket.class);
    private final AtmosphereConfig config;
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);

    public TomcatWebSocket(WsOutbound outbound, AtmosphereConfig config) {
        super(config);
        this.outbound = outbound;
        this.config = config;
    }

    @Override
    public WebSocket redirect(AtmosphereResponse r, String location) throws IOException {
        logger.error("WebSocket Redirect not supported");
        return this;
    }

    @Override
    public WebSocket writeError(AtmosphereResponse r, int errorCode, String message) throws IOException {
        if (!this.firstWrite.get()) {
            logger.debug("The WebSocket handshake succeeded but the dispatched URI failed with status {} : {} The WebSocket connection is still open and client can continue sending messages.", (Object)(errorCode + " " + message), (Object)this.retrieveUUID());
        } else {
            logger.debug("{} {}", (Object)errorCode, (Object)message);
        }
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, String data) throws IOException {
        this.firstWrite.set(true);
        logger.trace("WebSocket.write() for {}", (Object)(this.resource() != null ? this.resource().uuid() : ""));
        if (this.binaryWrite) {
            this.outbound.writeBinaryMessage(ByteBuffer.wrap(this.webSocketResponseFilter.filter(r, data).getBytes(this.resource().getResponse().getCharacterEncoding())));
        } else {
            this.outbound.writeTextMessage(CharBuffer.wrap(this.webSocketResponseFilter.filter(r, data)));
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data) throws IOException {
        this.firstWrite.set(true);
        logger.trace("WebSocket.write() for {}", (Object)(this.resource() != null ? this.resource().uuid() : ""));
        if (this.binaryWrite) {
            this.outbound.writeBinaryMessage(ByteBuffer.wrap(this.webSocketResponseFilter.filter(r, data)));
        } else {
            this.outbound.writeTextMessage(CharBuffer.wrap(this.webSocketResponseFilter.filter(r, new String(data, this.resource().getResponse().getCharacterEncoding()))));
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
        this.firstWrite.set(true);
        logger.trace("WebSocket.write() for {}", (Object)(this.resource() != null ? this.resource().uuid() : ""));
        if (this.binaryWrite) {
            if (!WebSocketResponseFilter.NoOpsWebSocketResponseFilter.class.isAssignableFrom(this.webSocketResponseFilter.getClass())) {
                byte[] b = this.webSocketResponseFilter.filter(r, data, offset, length);
                this.outbound.writeBinaryMessage(ByteBuffer.wrap(b));
            } else {
                this.outbound.writeBinaryMessage(ByteBuffer.wrap(data, offset, length));
            }
        } else {
            this.outbound.writeTextMessage(CharBuffer.wrap(this.webSocketResponseFilter.filter(r, new String(data, offset, length, this.resource().getResponse().getCharacterEncoding()))));
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public void close(AtmosphereResponse r) throws IOException {
        logger.trace("WebSocket.close() for AtmosphereResource {}", (Object)(this.resource() != null ? this.resource().uuid() : "null"));
        this.outbound.close(1005, ByteBuffer.wrap(new byte[0]));
    }

    @Override
    public WebSocket flush(AtmosphereResponse r) throws IOException {
        this.outbound.flush();
        return this;
    }

    public String toString() {
        return this.outbound.toString();
    }
}

