/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util.analytics;

import org.atmosphere.util.analytics.FocusPoint;
import org.atmosphere.util.analytics.GoogleAnalytics_v1_URLBuildingStrategy;
import org.atmosphere.util.analytics.HTTPGetMethod;
import org.atmosphere.util.analytics.URLBuildingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGoogleAnalyticsTracker {
    private URLBuildingStrategy urlBuildingStrategy = null;
    private HTTPGetMethod httpRequest = new HTTPGetMethod();
    private final Logger logger = LoggerFactory.getLogger(JGoogleAnalyticsTracker.class);

    public JGoogleAnalyticsTracker(String appName, String googleAnalyticsTrackingCode) {
        this.urlBuildingStrategy = new GoogleAnalytics_v1_URLBuildingStrategy(appName, googleAnalyticsTrackingCode);
    }

    public JGoogleAnalyticsTracker(String appName, String appVersion, String googleAnalyticsTrackingCode) {
        this.urlBuildingStrategy = new GoogleAnalytics_v1_URLBuildingStrategy(appName, appVersion, googleAnalyticsTrackingCode);
    }

    public void setUrlBuildingStrategy(URLBuildingStrategy urlBuildingStrategy) {
        this.urlBuildingStrategy = urlBuildingStrategy;
    }

    public void trackSynchronously(FocusPoint focusPoint) {
        this.logMessage("JGoogleAnalytics: Tracking synchronously focusPoint=" + focusPoint.getContentTitle());
        this.httpRequest.request(this.urlBuildingStrategy.buildURL(focusPoint));
    }

    public void trackAsynchronously(FocusPoint focusPoint) {
        this.logMessage("JGoogleAnalytics: Tracking Asynchronously focusPoint=" + focusPoint.getContentTitle());
        new TrackingThread(focusPoint).start();
    }

    private void logMessage(String message) {
        this.logger.trace("{}", (Object)message);
    }

    private class TrackingThread
    extends Thread {
        private FocusPoint focusPoint;

        public TrackingThread(FocusPoint focusPoint) {
            this.focusPoint = focusPoint;
            this.setPriority(1);
        }

        @Override
        public void run() {
            JGoogleAnalyticsTracker.this.httpRequest.request(JGoogleAnalyticsTracker.this.urlBuildingStrategy.buildURL(this.focusPoint));
        }
    }
}

