/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.client;

import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncIOWriterAdapter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketResponseFilter;

public class MessageLengthInterceptor
implements AtmosphereInterceptor {
    private static final byte[] END = "|".getBytes();
    private byte[] end = END;
    private String endString = "|";

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(ApplicationConfig.MESSAGE_DELIMITER);
        if (s != null) {
            this.end = s.getBytes();
            this.endString = s;
        }
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        final AtmosphereResponse response = r.getResponse();
        if (r.transport() != AtmosphereResource.TRANSPORT.WEBSOCKET) {
            response.asyncIOWriter(new AsyncIOWriterAdapter(){

                @Override
                public AsyncIOWriter redirect(String location) throws IOException {
                    response.sendRedirect(location);
                    return this;
                }

                @Override
                public AsyncIOWriter writeError(int errorCode, String message) throws IOException {
                    response.sendError(errorCode);
                    return this;
                }

                @Override
                public AsyncIOWriter write(String data) throws IOException {
                    response.write(data + MessageLengthInterceptor.this.endString);
                    return this;
                }

                @Override
                public AsyncIOWriter write(byte[] data) throws IOException {
                    response.write(data).write(MessageLengthInterceptor.this.end);
                    return this;
                }

                @Override
                public AsyncIOWriter write(byte[] data, int offset, int length) throws IOException {
                    response.write(data, offset, length).write(MessageLengthInterceptor.this.end);
                    return this;
                }

                @Override
                public void close() throws IOException {
                    response.closeStreamOrWriter();
                }

                @Override
                public AsyncIOWriter flush() throws IOException {
                    response.flushBuffer();
                    return this;
                }
            });
        } else {
            ((WebSocket)response.getAsyncIOWriter()).webSocketResponseFilter(new WebSocketResponseFilter(){

                @Override
                public String filter(AtmosphereResponse r, String message) {
                    return message + MessageLengthInterceptor.this.endString;
                }

                @Override
                public byte[] filter(AtmosphereResponse r, byte[] message) {
                    byte[] nb = new byte[message.length + MessageLengthInterceptor.this.end.length];
                    System.arraycopy(message, 0, nb, 0, message.length);
                    System.arraycopy(MessageLengthInterceptor.this.end, 0, nb, message.length, nb.length);
                    return nb;
                }

                @Override
                public byte[] filter(AtmosphereResponse r, byte[] message, int offset, int length) {
                    byte[] nb = new byte[length + MessageLengthInterceptor.this.end.length];
                    System.arraycopy(message, offset, nb, 0, length);
                    System.arraycopy(MessageLengthInterceptor.this.end, 0, nb, length, nb.length);
                    return nb;
                }
            });
        }
        return Action.CONTINUE;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
    }

    public String toString() {
        return this.endString + " End Message Interceptor";
    }
}

