/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import javax.servlet.http.HttpSession;
import org.atmosphere.cache.BroadcasterCacheBase;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionBroadcasterCache
extends BroadcasterCacheBase {
    private static final Logger logger = LoggerFactory.getLogger(SessionBroadcasterCache.class);
    private static final String ERROR_MESSAGE = "Session was null. The request has been recycled by the underlying container";

    @Override
    public void cache(AtmosphereResource r, BroadcasterCacheBase.CachedMessage cm) {
        if (r != null) {
            HttpSession session = r.session();
            if (session == null) {
                logger.error(ERROR_MESSAGE);
                return;
            }
            session.setAttribute(BROADCASTER_CACHE_TRACKER, (Object)cm);
        }
    }

    @Override
    public BroadcasterCacheBase.CachedMessage retrieveLastMessage(AtmosphereResource r) {
        HttpSession session = r.session();
        if (session == null) {
            logger.error(ERROR_MESSAGE);
            return null;
        }
        return (BroadcasterCacheBase.CachedMessage)session.getAttribute(BROADCASTER_CACHE_TRACKER);
    }
}

