/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.DefaultWebSocket;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketEngine;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.container.version.GrizzlyWebSocket;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.Utils;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlassFishWebSocketSupport
extends GrizzlyCometSupport {
    private static final Logger logger = LoggerFactory.getLogger(GlassFishWebSocketSupport.class);
    private GrizzlyApplication application;

    public GlassFishWebSocketSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.application = new GrizzlyApplication(this.config);
        WebSocketEngine.getEngine().register((WebSocketApplication)this.application);
    }

    @Override
    public void shutdown() {
        WebSocketEngine.getEngine().unregister((WebSocketApplication)this.application);
        super.shutdown();
    }

    @Override
    public Action service(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        if (!Utils.webSocketEnabled((HttpServletRequest)request)) {
            return super.service(request, response);
        }
        return this.suspended(request, response);
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    private static final class GrizzlyApplication
    extends WebSocketApplication {
        private final AtmosphereConfig config;

        public GrizzlyApplication(AtmosphereConfig config) {
            this.config = config;
        }

        public void onConnect(WebSocket w) {
            super.onConnect(w);
            if (!DefaultWebSocket.class.isAssignableFrom(w.getClass())) {
                throw new IllegalStateException();
            }
            DefaultWebSocket webSocket = (DefaultWebSocket)DefaultWebSocket.class.cast(w);
            try {
                AtmosphereRequest r = AtmosphereRequest.wrap(webSocket.getRequest());
                try {
                    if (r.getPathInfo().startsWith(r.getContextPath())) {
                        r.servletPath(r.getPathInfo().substring(r.getContextPath().length()));
                        r.pathInfo(null);
                    }
                }
                catch (Exception e) {
                    logger.trace("", (Throwable)e);
                }
                WebSocketProcessor webSocketProcessor = new WebSocketProcessor(this.config.framework(), new GrizzlyWebSocket((WebSocket)webSocket, this.config), this.config.framework().getWebSocketProtocol());
                webSocket.getRequest().setAttribute("grizzly.webSocketProcessor", (Object)webSocketProcessor);
                webSocketProcessor.dispatch(r);
            }
            catch (Exception e) {
                logger.warn("failed to connect to web socket", (Throwable)e);
            }
        }

        public boolean isApplicationRequest(Request request) {
            return true;
        }

        public void onClose(WebSocket w, DataFrame df) {
            super.onClose(w, df);
            logger.trace("onClose {} ", (Object)w);
            DefaultWebSocket webSocket = (DefaultWebSocket)DefaultWebSocket.class.cast(w);
            if (webSocket.getRequest().getAttribute("grizzly.webSocketProcessor") != null) {
                WebSocketProcessor webSocketProcessor = (WebSocketProcessor)webSocket.getRequest().getAttribute("grizzly.webSocketProcessor");
                webSocketProcessor.close(1000);
            }
        }

        public void onMessage(WebSocket w, String text) {
            logger.trace("onMessage {} ", (Object)w);
            DefaultWebSocket webSocket = (DefaultWebSocket)DefaultWebSocket.class.cast(w);
            if (webSocket.getRequest().getAttribute("grizzly.webSocketProcessor") != null) {
                WebSocketProcessor webSocketProcessor = (WebSocketProcessor)webSocket.getRequest().getAttribute("grizzly.webSocketProcessor");
                webSocketProcessor.invokeWebSocketProtocol(text);
            }
        }

        public void onMessage(WebSocket w, byte[] bytes) {
            logger.trace("onMessage (bytes) {} ", (Object)w);
            DefaultWebSocket webSocket = (DefaultWebSocket)DefaultWebSocket.class.cast(w);
            if (webSocket.getRequest().getAttribute("grizzly.webSocketProcessor") != null) {
                WebSocketProcessor webSocketProcessor = (WebSocketProcessor)webSocket.getRequest().getAttribute("grizzly.webSocketProcessor");
                webSocketProcessor.invokeWebSocketProtocol(bytes, 0, bytes.length);
            }
        }

        public void onPing(WebSocket w, byte[] bytes) {
            logger.trace("onPing (bytes) {} ", (Object)w);
        }

        public void onPong(WebSocket w, byte[] bytes) {
            logger.trace("onPong (bytes) {} ", (Object)w);
        }

        public void onFragment(WebSocket w, byte[] bytes, boolean last) {
            logger.trace("onFragment (bytes) {} ", (Object)w);
        }

        public void onFragment(WebSocket w, String text, boolean last) {
            logger.trace("onFragment (string) {} ", (Object)w);
        }
    }
}

