/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.atmosphere.cache.BroadcasterCacheBase;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcastFilterLifecycle;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.PerRequestBroadcastFilter;
import org.atmosphere.di.InjectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcasterConfig {
    private static final Logger logger = LoggerFactory.getLogger(BroadcasterConfig.class);
    protected final ConcurrentLinkedQueue<BroadcastFilter> filters = new ConcurrentLinkedQueue();
    protected final ConcurrentLinkedQueue<PerRequestBroadcastFilter> perRequestFilters = new ConcurrentLinkedQueue();
    private ExecutorService executorService;
    private ExecutorService asyncWriteService;
    private ExecutorService defaultExecutorService;
    private ExecutorService defaultAsyncWriteService;
    private ScheduledExecutorService scheduler;
    private final Object[] lock = new Object[0];
    private BroadcasterCache broadcasterCache;
    private AtmosphereConfig config;
    private boolean isExecutorShared = false;
    private boolean isAsyncExecutorShared = false;
    private boolean shared = false;

    public BroadcasterConfig(List<String> list, AtmosphereConfig config) {
        this(list, config, true);
    }

    public BroadcasterConfig(List<String> list, AtmosphereConfig config, boolean createExecutor) {
        this.config = config;
        if (createExecutor) {
            this.configExecutors();
        } else {
            this.shared = true;
        }
        this.configureBroadcasterFilter(list);
        this.configureBroadcasterCache();
    }

    public BroadcasterConfig(ExecutorService executorService, ExecutorService asyncWriteService, ScheduledExecutorService scheduler, AtmosphereConfig config) {
        this.executorService = executorService;
        this.scheduler = scheduler;
        this.asyncWriteService = asyncWriteService;
        this.config = config;
    }

    private void configureBroadcasterCache() {
        try {
            if (AtmosphereFramework.broadcasterCacheClassName != null) {
                BroadcasterCache cache = (BroadcasterCache)Thread.currentThread().getContextClassLoader().loadClass(AtmosphereFramework.broadcasterCacheClassName).newInstance();
                InjectorProvider.getInjector().inject(cache);
                this.setBroadcasterCache(cache);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected synchronized void configExecutors() {
        String s = this.config.getInitParameter(ApplicationConfig.BROADCASTER_SHARABLE_THREAD_POOLS);
        if (Boolean.parseBoolean(s)) {
            this.isExecutorShared = true;
            this.isAsyncExecutorShared = true;
        }
        if (this.config.properties().get("executorService") == null) {
            int numberOfMessageProcessingThread = 1;
            s = this.config.getInitParameter(ApplicationConfig.BROADCASTER_MESSAGE_PROCESSING_THREADPOOL_MAXSIZE);
            if (s != null) {
                numberOfMessageProcessingThread = Integer.parseInt(s);
            }
            if (this.isExecutorShared && numberOfMessageProcessingThread == 1) {
                logger.warn("Not enought numberOfMessageProcessingThread for a shareable thread pool {}, Setting it to a newCachedThreadPool", (Object)numberOfMessageProcessingThread);
                numberOfMessageProcessingThread = -1;
            }
            int numberOfAsyncThread = 1;
            s = this.config.getInitParameter(ApplicationConfig.BROADCASTER_ASYNC_WRITE_THREADPOOL_MAXSIZE);
            if (s != null) {
                numberOfAsyncThread = Integer.parseInt(s);
            }
            if (this.isAsyncExecutorShared && numberOfAsyncThread == 1) {
                logger.warn("Not enought numberOfAsyncThread for a shareable thread pool {}, Setting it to a newCachedThreadPool", (Object)numberOfAsyncThread);
                numberOfAsyncThread = -1;
            }
            this.executorService = numberOfMessageProcessingThread == -1 ? Executors.newCachedThreadPool(new ThreadFactory(){
                private final AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = new Thread(runnable, "Atmosphere-BroadcasterConfig-" + this.count.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            }) : Executors.newFixedThreadPool(numberOfMessageProcessingThread, new ThreadFactory(){
                private final AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = new Thread(runnable, "Atmosphere-BroadcasterConfig-" + this.count.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            });
            this.defaultExecutorService = this.executorService;
            this.asyncWriteService = numberOfAsyncThread == -1 ? Executors.newCachedThreadPool(new ThreadFactory(){
                private final AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = new Thread(runnable, "Atmosphere-AsyncWrite-" + this.count.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            }) : Executors.newFixedThreadPool(numberOfAsyncThread, new ThreadFactory(){
                private final AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = new Thread(runnable, "Atmosphere-AsyncWrite-" + this.count.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            });
            this.defaultAsyncWriteService = this.asyncWriteService;
            if (this.isExecutorShared) {
                this.config.properties().put("executorService", this.executorService);
                this.config.properties().put("asyncWriteService", this.asyncWriteService);
            }
        } else {
            this.defaultExecutorService = this.executorService = (ExecutorService)this.config.properties().get("executorService");
            this.defaultAsyncWriteService = this.asyncWriteService = (ExecutorService)this.config.properties().get("asyncWriteService");
        }
    }

    public BroadcasterConfig setExecutorService(ExecutorService executorService) {
        return this.setExecutorService(executorService, false);
    }

    public BroadcasterConfig setExecutorService(ExecutorService executorService, boolean isExecutorShared) {
        if (!this.isExecutorShared && this.executorService != null) {
            this.executorService.shutdown();
        }
        this.executorService = executorService;
        this.isExecutorShared = isExecutorShared;
        return this;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public BroadcasterConfig setAsyncWriteService(ExecutorService asyncWriteService) {
        return this.setAsyncWriteService(asyncWriteService, false);
    }

    public BroadcasterConfig setAsyncWriteService(ExecutorService asyncWriteService, boolean isAsyncExecutorShared) {
        if (!this.isAsyncExecutorShared && this.asyncWriteService != null) {
            this.asyncWriteService.shutdown();
        }
        this.asyncWriteService = asyncWriteService;
        this.isAsyncExecutorShared = isAsyncExecutorShared;
        return this;
    }

    public ExecutorService getAsyncWriteService() {
        return this.asyncWriteService;
    }

    public boolean addFilter(BroadcastFilter e) {
        this.logDuplicateFilter(e);
        if (this.filters.contains(e)) {
            return false;
        }
        if (e instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)e).init();
        }
        if (e instanceof PerRequestBroadcastFilter) {
            this.perRequestFilters.add((PerRequestBroadcastFilter)e);
        }
        return this.filters.offer(e);
    }

    private void logDuplicateFilter(BroadcastFilter e) {
        for (BroadcastFilter f : this.filters) {
            if (!f.getClass().isAssignableFrom(e.getClass())) continue;
            logger.trace("Duplicate Filter instance {}", f.getClass());
        }
    }

    public void destroy() {
        this.destroy(false);
    }

    protected void destroy(boolean force) {
        if (this.shared) {
            return;
        }
        if (this.broadcasterCache != null) {
            this.broadcasterCache.stop();
        }
        if ((force || !this.isExecutorShared) && this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if ((force || !this.isAsyncExecutorShared) && this.asyncWriteService != null) {
            this.asyncWriteService.shutdownNow();
        }
        if ((force || !this.isExecutorShared) && this.defaultExecutorService != null) {
            this.defaultExecutorService.shutdownNow();
        }
        if ((force || !this.isAsyncExecutorShared) && this.defaultAsyncWriteService != null) {
            this.defaultAsyncWriteService.shutdownNow();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        for (BroadcastFilter f : this.filters) {
            if (!(f instanceof BroadcastFilterLifecycle)) continue;
            ((BroadcastFilterLifecycle)f).destroy();
        }
        this.removeAllFilters();
    }

    public void forceDestroy() {
        this.destroy(true);
    }

    public boolean removeFilter(BroadcastFilter filter) {
        if (filter instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)filter).destroy();
        }
        if (filter instanceof PerRequestBroadcastFilter) {
            this.perRequestFilters.remove(filter);
        }
        return this.filters.remove(filter);
    }

    public void removeAllFilters() {
        for (BroadcastFilter filter : this.filters) {
            this.removeFilter(filter);
        }
    }

    public boolean hasFilters() {
        return !this.filters.isEmpty();
    }

    public boolean hasPerRequestFilters() {
        if (this.filters.isEmpty()) {
            return false;
        }
        for (BroadcastFilter b : this.filters) {
            if (!PerRequestBroadcastFilter.class.isAssignableFrom(b.getClass())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BroadcastFilter.BroadcastAction filter(Object object) {
        BroadcastFilter.BroadcastAction transformed = new BroadcastFilter.BroadcastAction(object);
        Iterator<BroadcastFilter> i$ = this.filters.iterator();
        while (i$.hasNext()) {
            BroadcastFilter mf;
            BroadcastFilter broadcastFilter = mf = i$.next();
            synchronized (broadcastFilter) {
                transformed = mf.filter(object, transformed.message());
                if (transformed == null || transformed.action() == BroadcastFilter.BroadcastAction.ACTION.ABORT) {
                    return transformed;
                }
            }
        }
        return transformed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BroadcastFilter.BroadcastAction filter(AtmosphereResource r, Object message, Object originalMessage) {
        BroadcastFilter.BroadcastAction transformed = new BroadcastFilter.BroadcastAction(originalMessage);
        Iterator<PerRequestBroadcastFilter> i$ = this.perRequestFilters.iterator();
        while (i$.hasNext()) {
            PerRequestBroadcastFilter mf;
            PerRequestBroadcastFilter perRequestBroadcastFilter = mf = i$.next();
            synchronized (perRequestBroadcastFilter) {
                transformed = mf.filter(r, message, transformed.message());
                if (transformed == null || transformed.action() == BroadcastFilter.BroadcastAction.ACTION.ABORT) {
                    return transformed;
                }
            }
        }
        return transformed;
    }

    public ExecutorService getDefaultExecutorService() {
        return this.defaultExecutorService;
    }

    public BroadcasterConfig setScheduledExecutorService(ScheduledExecutorService scheduler) {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        this.scheduler = scheduler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledExecutorService getScheduledExecutorService() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            if (this.scheduler == null) {
                this.scheduler = Executors.newSingleThreadScheduledExecutor();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.scheduler;
        }
    }

    public BroadcasterConfig setBroadcasterCache(BroadcasterCache broadcasterCache) {
        this.broadcasterCache = broadcasterCache;
        if (BroadcasterCacheBase.class.isAssignableFrom(broadcasterCache.getClass())) {
            ((BroadcasterCacheBase)BroadcasterCacheBase.class.cast(broadcasterCache)).setExecutorService(this.getScheduledExecutorService());
        }
        return this;
    }

    public BroadcasterCache getBroadcasterCache() {
        if (this.broadcasterCache == null) {
            this.broadcasterCache = new DefaultBroadcasterCache();
        }
        return this.broadcasterCache;
    }

    void configureBroadcasterFilter(List<String> list) {
        for (String broadcastFilter : list) {
            BroadcastFilter bf = null;
            try {
                bf = (BroadcastFilter)BroadcastFilter.class.cast(Thread.currentThread().getContextClassLoader().loadClass(broadcastFilter).newInstance());
            }
            catch (InstantiationException e) {
                logger.warn("Error trying to instantiate BroadcastFilter: " + broadcastFilter, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.warn("Error trying to instantiate BroadcastFilter: " + broadcastFilter, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                try {
                    bf = (BroadcastFilter)BroadcastFilter.class.cast(BroadcastFilter.class.getClassLoader().loadClass(broadcastFilter).newInstance());
                }
                catch (InstantiationException e1) {
                }
                catch (IllegalAccessException e1) {
                }
                catch (ClassNotFoundException e1) {
                    logger.warn("Error trying to instantiate BroadcastFilter: " + broadcastFilter, (Throwable)e);
                }
            }
            if (bf == null) continue;
            InjectorProvider.getInjector().inject(bf);
            this.addFilter(bf);
        }
    }

    public AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public void setAtmosphereConfig(AtmosphereConfig config) {
        this.config = config;
    }

    public static class DefaultBroadcasterCache
    implements BroadcasterCache {
        private final List<Object> list = new ArrayList<Object>();

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void addToCache(AtmosphereResource r, Object e) {
        }

        @Override
        public List<Object> retrieveFromCache(AtmosphereResource r) {
            return this.list;
        }
    }
}

