/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncIOWriterAdapter;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSEAtmosphereInterceptor
implements AtmosphereInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SSEAtmosphereInterceptor.class);
    private static final byte[] padding;

    @Override
    public Action inspect(AtmosphereResource r) {
        final AtmosphereResponse response = r.getResponse();
        if (r.transport().equals((Object)AtmosphereResource.TRANSPORT.SSE)) {
            r.addEventListener(new AtmosphereResourceEventListenerAdapter(){

                @Override
                public void onSuspend(AtmosphereResourceEvent event) {
                    response.setContentType("text/event-stream");
                    response.setCharacterEncoding("utf-8");
                    ServletOutputStream stream = null;
                    try {
                        stream = response.getOutputStream();
                    }
                    catch (IOException e) {
                        logger.trace("", (Throwable)e);
                    }
                    try {
                        stream.write(padding);
                        stream.flush();
                    }
                    catch (IOException ex) {
                        logger.warn("SSE may not work", (Throwable)ex);
                    }
                }
            });
            response.asyncIOWriter(new AsyncIOWriterAdapter(){

                @Override
                public AsyncIOWriter redirect(String location) throws IOException {
                    response.sendRedirect(location);
                    return this;
                }

                @Override
                public AsyncIOWriter writeError(int errorCode, String message) throws IOException {
                    response.sendError(errorCode);
                    return this;
                }

                @Override
                public AsyncIOWriter write(String data) throws IOException {
                    response.write("data:" + data + "\n\n");
                    return this;
                }

                @Override
                public AsyncIOWriter write(byte[] data) throws IOException {
                    response.write("data:").write(data).write("\n\n");
                    return this;
                }

                @Override
                public AsyncIOWriter write(byte[] data, int offset, int length) throws IOException {
                    response.write("data:").write(data, offset, length).write("\n\n");
                    return this;
                }

                @Override
                public void close() throws IOException {
                    response.closeStreamOrWriter();
                }

                @Override
                public AsyncIOWriter flush() throws IOException {
                    response.flushBuffer();
                    return this;
                }
            });
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return "SSE Interceptor Support";
    }

    static {
        StringBuffer whitespace = new StringBuffer();
        for (int i = 0; i < 2000; ++i) {
            whitespace.append(" ");
        }
        whitespace.append("\n");
        padding = whitespace.toString().getBytes();
    }
}

