/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class FakeHttpSession
implements HttpSession {
    private final long creationTime;
    private final ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap();
    private final String sessionId;
    private final ServletContext servletContext;
    private int maxInactiveInterval;

    public FakeHttpSession(String sessionId, ServletContext servletContext, long creationTime) {
        this.sessionId = sessionId;
        this.servletContext = servletContext;
        this.creationTime = creationTime;
    }

    public void destroy() {
        this.attributes.clear();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object getValue(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.attributes.keys();
    }

    public String[] getValueNames() {
        return (String[])Collections.list(this.attributes.keys()).toArray();
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void putValue(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void removeValue(String name) {
        this.attributes.remove(name);
    }

    public void invalidate() {
    }

    public boolean isNew() {
        return false;
    }
}

