/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBroadcasterProxy
extends DefaultBroadcaster {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBroadcasterProxy.class);
    private Method jerseyBroadcast;

    public AbstractBroadcasterProxy(String id, URI uri, AtmosphereConfig config) {
        super(id, uri, config);
    }

    public abstract void incomingBroadcast();

    public abstract void outgoingBroadcast(Object var1);

    @Override
    protected Runnable getBroadcastHandler() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractBroadcasterProxy.this.incomingBroadcast();
                }
                catch (Throwable t) {
                    logger.debug("incomingBroadcast Exception. Broadcaster will be broken unless reconfigured", t);
                    AbstractBroadcasterProxy.this.destroy();
                    return;
                }
            }
        };
    }

    protected void reconfigure() {
        if (!this.started.get()) {
            return;
        }
        logger.debug("Reconfiguring Broadcaster {}", (Object)this.getID());
        if (this.notifierFuture != null) {
            this.notifierFuture.cancel(true);
        }
        if (this.asyncWriteFuture != null) {
            this.asyncWriteFuture.cancel(true);
        }
        this.notifierFuture = this.bc.getExecutorService().submit(this.getBroadcastHandler());
        this.asyncWriteFuture = this.bc.getAsyncWriteService().submit(this.getAsyncWriteHandler());
    }

    @Override
    protected void broadcast(AtmosphereResource<?, ?> r, AtmosphereResourceEvent e) {
        if (r.getRequest() instanceof HttpServletRequest) {
            if (((HttpServletRequest)r.getRequest()).getAttribute("org.atmosphere.jersey.containerResponse") != null) {
                try {
                    if (this.jerseyBroadcast == null) {
                        Class<?> jerseyBroadcasterUtil = Class.forName("org.atmosphere.jersey.util.JerseyBroadcasterUtil");
                        this.jerseyBroadcast = jerseyBroadcasterUtil.getMethod("broadcast", AtmosphereResource.class, AtmosphereResourceEvent.class);
                    }
                    this.jerseyBroadcast.invoke(null, r, e);
                }
                catch (Throwable t) {
                    super.broadcast(r, e);
                }
            } else {
                super.broadcast(r, e);
            }
        }
    }

    protected void broadcastReceivedMessage(Object message) {
        try {
            Object newMsg = this.filter(message);
            this.push(new DefaultBroadcaster.Entry(newMsg, null, new BroadcasterFuture<Object>(newMsg), message));
        }
        catch (Throwable t) {
            logger.error("failed to push message: " + message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> broadcast(T msg) {
        if (this.destroyed.get()) {
            logger.warn("This Broadcaster has been destroyed and cannot be used {}", (Object)this.getID());
            return null;
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        try {
            this.outgoingBroadcast(msg);
            this.push(new DefaultBroadcaster.Entry(newMsg, (Object)null, (BroadcasterFuture<?>)f, false));
        }
        finally {
            f.done();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> broadcast(T msg, AtmosphereResource<?, ?> r) {
        if (this.destroyed.get()) {
            logger.warn("This Broadcaster has been destroyed and cannot be used {}", (Object)this.getID());
            return null;
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        try {
            this.outgoingBroadcast(msg);
            this.push(new DefaultBroadcaster.Entry(newMsg, (Object)r, (BroadcasterFuture<?>)f, false));
        }
        finally {
            f.done();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> broadcast(T msg, Set<AtmosphereResource<?, ?>> subset) {
        if (this.destroyed.get()) {
            logger.warn("This Broadcaster has been destroyed and cannot be used {}", (Object)this.getID());
            return null;
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        try {
            this.outgoingBroadcast(msg);
            this.push(new DefaultBroadcaster.Entry(newMsg, (Object)subset, (BroadcasterFuture<?>)f, false));
        }
        finally {
            f.done();
        }
        return f;
    }
}

