/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.atmosphere.config.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.BroadcasterFactory;

public class AtmosphereConfig {
    private final List<AtmosphereHandler> atmosphereHandler = new ArrayList<AtmosphereHandler>();
    private boolean supportSession = true;
    private BroadcasterFactory broadcasterFactory;
    private String dispatcherName = "default";
    private final AtmosphereServlet atmosphereServlet;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public AtmosphereConfig(AtmosphereServlet atmosphereServlet) {
        this.atmosphereServlet = atmosphereServlet;
    }

    public List<AtmosphereHandler> getAtmosphereHandler() {
        return this.atmosphereHandler;
    }

    public AtmosphereServlet getServlet() {
        return this.atmosphereServlet;
    }

    public ServletConfig getServletConfig() {
        return this.atmosphereServlet.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.atmosphereServlet.getServletContext();
    }

    public String getWebServerName() {
        return this.atmosphereServlet.getCometSupport().getContainerName();
    }

    public Map<String, AtmosphereServlet.AtmosphereHandlerWrapper> handlers() {
        return this.atmosphereServlet.getAtmosphereHandlers();
    }

    public String getInitParameter(String name) {
        String s = this.atmosphereServlet.initParams.get(name);
        if (s != null) {
            return s;
        }
        try {
            return this.atmosphereServlet.getInitParameter(name);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public Enumeration<String> getInitParameterNames() {
        HashMap<String, String> map = new HashMap<String, String>(this.atmosphereServlet.initParams);
        Enumeration en = this.atmosphereServlet.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (map.containsKey(name)) continue;
            map.put(name, name);
        }
        Vector v = new Vector(map.keySet());
        return v.elements();
    }

    public boolean isSupportSession() {
        return this.supportSession;
    }

    public void setSupportSession(boolean supportSession) {
        this.supportSession = supportSession;
    }

    public BroadcasterFactory getBroadcasterFactory() {
        return this.broadcasterFactory;
    }

    public void setBroadcasterFactory(BroadcasterFactory broadcasterFactory) {
        this.broadcasterFactory = broadcasterFactory;
    }

    public String getDispatcherName() {
        return this.dispatcherName;
    }

    public void setDispatcherName(String dispatcherName) {
        this.dispatcherName = dispatcherName;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }
}

