/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyCometSupport
extends AsynchronousProcessor {
    public static final String SUSPEND = NettyCometSupport.class.getName() + ".suspend";
    public static final String RESUME = NettyCometSupport.class.getName() + ".resume";
    public static final String HOOK = NettyCometSupport.class.getName() + ".cometSupportHook";
    public static final String CHANNEL = NettyCometSupport.class.getName() + ".channel";
    private static final Logger logger = LoggerFactory.getLogger(NettyCometSupport.class);

    public NettyCometSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = null;
        action = this.suspended(req, res);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)res);
            req.setAttribute(SUSPEND, (Object)action);
            req.setAttribute(HOOK, (Object)new CometSupportHook(req, res));
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            logger.debug("Resuming response: {}", (Object)res);
            AtmosphereServlet.Action nextAction = this.resumed(req, res);
            if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                logger.debug("Suspending after resuming response: {}", (Object)res);
                req.setAttribute(SUSPEND, (Object)action);
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        super.action(r);
        if (r.isResumed()) {
            ((CometSupportHook)r.getRequest().getAttribute(HOOK)).resume();
        }
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    public final class CometSupportHook {
        private final HttpServletRequest req;
        private final HttpServletResponse res;

        public CometSupportHook(HttpServletRequest req, HttpServletResponse res) {
            this.req = req;
            this.res = res;
        }

        public void closed() {
            try {
                NettyCometSupport.this.cancelled(this.req, this.res);
            }
            catch (IOException e) {
                logger.debug("", (Throwable)e);
            }
            catch (ServletException e) {
                logger.debug("", (Throwable)e);
            }
        }

        public void timedOut() {
            try {
                NettyCometSupport.this.timedout(this.req, this.res);
            }
            catch (IOException e) {
                logger.debug("", (Throwable)e);
            }
            catch (ServletException e) {
                logger.debug("", (Throwable)e);
            }
        }

        public void resume() {
            try {
                ((AsyncIOWriter)this.req.getAttribute(CHANNEL)).close();
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
        }
    }
}

