/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.FrameworkConfig;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty7CometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Jetty7CometSupport.class);

    public Jetty7CometSupport(AtmosphereConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtmosphereServlet.Action service(final HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = null;
        Continuation c = (Continuation)req.getAttribute(Continuation.class.getName());
        if (c == null || c.isInitial()) {
            action = this.suspended(req, res);
            if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND && req.getAttribute("doNotSuspend") == null) {
                c = ContinuationSupport.getContinuation((ServletRequest)req);
                req.setAttribute(Continuation.class.getName(), (Object)c);
                if (action.timeout != -1L) {
                    c.setTimeout(action.timeout);
                } else {
                    c.setTimeout(Integer.MAX_VALUE);
                }
                c.setAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE, req.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE));
                c.addContinuationListener(new ContinuationListener(){

                    public void onComplete(Continuation continuation) {
                        AtmosphereResourceImpl r = (AtmosphereResourceImpl)req.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
                        if (r != null) {
                            try {
                                r.cancel();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }

                    public void onTimeout(Continuation continuation) {
                        AtmosphereResourceImpl r = (AtmosphereResourceImpl)req.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
                        if (r != null) {
                            try {
                                Jetty7CometSupport.this.timedout(r.getRequest(), r.getResponse());
                            }
                            catch (Throwable t) {
                                logger.error("", t);
                            }
                        } else {
                            logger.trace("AtmosphereResource was null");
                        }
                        try {
                            continuation.complete();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                if (req.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE) != null) {
                    c.suspend((ServletResponse)res);
                }
            } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
                Boolean resumeOnBroadcast = (Boolean)req.getAttribute("org.atmosphere.resumeOnBroadcast");
                if (resumeOnBroadcast != null && resumeOnBroadcast.booleanValue()) {
                    return action;
                }
                c = (Continuation)req.getAttribute(Continuation.class.getName());
                if (c != null && c.isSuspended()) {
                    try {
                        c.complete();
                    }
                    catch (IllegalStateException ex) {
                        logger.trace("Continuation.complete()", (Throwable)ex);
                    }
                    finally {
                        this.resumed(req, res);
                    }
                }
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtmosphereServlet.Action resumed(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)request.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        AtmosphereHandler atmosphereHandler = (AtmosphereHandler)request.getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER);
        AtmosphereResourceImpl atmosphereResourceImpl = r;
        synchronized (atmosphereResourceImpl) {
            atmosphereHandler.onStateChange(r.getAtmosphereResourceEvent());
        }
        return new AtmosphereServlet.Action(AtmosphereServlet.Action.TYPE.RESUME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void action(AtmosphereResourceImpl r) {
        super.action(r);
        HttpServletRequest request = r.getRequest(false);
        while (request != null) {
            Continuation c = (Continuation)request.getAttribute(Continuation.class.getName());
            if (c != null) {
                try {
                    if (c.isSuspended()) {
                        c.complete();
                    }
                }
                catch (IllegalStateException ex) {
                    logger.trace("c.complete()", (Throwable)ex);
                }
                finally {
                    r.getRequest(false).setAttribute("doNotSuspend", (Object)true);
                }
                request.removeAttribute(Continuation.class.getName());
                return;
            }
            if (AtmosphereRequest.class.isAssignableFrom(request.getClass())) {
                request = ((AtmosphereRequest)((Object)AtmosphereRequest.class.cast(request))).getRequest();
                continue;
            }
            return;
        }
    }
}

