/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.jboss.servlet.http.HttpEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingIOCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BlockingIOCometSupport.class);
    protected static final String LATCH = BlockingIOCometSupport.class.getName() + ".latch";

    public BlockingIOCometSupport(AtmosphereConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = null;
        try {
            action = this.suspended(req, res);
            if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                logger.debug("Suspending response: {}", (Object)res);
                this.suspend(action, req, res);
            } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
                logger.debug("Resuming response: {}", (Object)res);
                CountDownLatch latch = (CountDownLatch)req.getAttribute(LATCH);
                if (latch == null && req.getAttribute(AtmosphereResourceImpl.PRE_SUSPEND) == null) {
                    logger.debug("response wasn't suspended: {}", (Object)res);
                    AtmosphereServlet.Action action2 = action;
                    return action2;
                }
                latch.countDown();
                AtmosphereServlet.Action nextAction = this.resumed(req, res);
                if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                    logger.debug("Suspending after resuming response: {}", (Object)res);
                    this.suspend(action, req, res);
                }
            }
        }
        finally {
            HttpEvent he;
            CometEvent event = (CometEvent)req.getAttribute("CometEvent");
            if (event != null) {
                event.close();
            }
            if ((he = (HttpEvent)req.getAttribute("HttpEvent")) != null) {
                he.close();
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend(AtmosphereServlet.Action action, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CountDownLatch latch = new CountDownLatch(1);
        req.setAttribute(LATCH, (Object)latch);
        try {
            if (action.timeout != -1L) {
                latch.await(action.timeout, TimeUnit.MILLISECONDS);
            } else {
                latch.await();
            }
        }
        catch (InterruptedException ex) {
            logger.debug("", (Throwable)ex);
        }
        finally {
            this.timedout(req, res);
        }
    }

    @Override
    public AtmosphereServlet.Action cancelled(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action a = super.cancelled(req, res);
        if (req.getAttribute(LATCH) != null) {
            CountDownLatch latch = (CountDownLatch)req.getAttribute(LATCH);
            latch.countDown();
        }
        return a;
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        try {
            super.action(r);
            if (r.action().type == AtmosphereServlet.Action.TYPE.RESUME) {
                HttpServletRequest req = r.getRequest(false);
                CountDownLatch latch = null;
                if (req.getAttribute(LATCH) != null) {
                    latch = (CountDownLatch)req.getAttribute(LATCH);
                }
                String s = this.config.getInitParameter(ApplicationConfig.RESUME_AND_KEEPALIVE);
                if (latch != null && (s == null || s.equalsIgnoreCase("false"))) {
                    latch.countDown();
                } else if (req.getAttribute(AtmosphereResourceImpl.PRE_SUSPEND) == null) {
                    logger.error("Unable to resume the suspended connection");
                }
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }
}

