/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.di;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import org.atmosphere.di.ServletContextProvider;

public final class ServletContextHolder {
    private static AtomicReference<WeakReference<ServletContextProvider>> PROVIDER = new AtomicReference();

    private ServletContextHolder() {
    }

    public static void register(ServletContextProvider provider) {
        PROVIDER.set(new WeakReference<ServletContextProvider>(provider));
    }

    public static ServletContext getServletContext() {
        ServletContextProvider provider;
        WeakReference<ServletContextProvider> ref = PROVIDER.get();
        if (ref != null && (provider = (ServletContextProvider)ref.get()) != null) {
            return provider.getServletContext();
        }
        throw new IllegalStateException("No " + ServletContextProvider.class.getSimpleName() + " found.");
    }
}

