/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.websocket.WebSocketAdapter;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty8WebSocket
extends WebSocketAdapter {
    private static final Logger logger = LoggerFactory.getLogger(Jetty8WebSocket.class);
    private final WebSocket.Connection connection;
    private final AtmosphereConfig config;
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);

    public Jetty8WebSocket(WebSocket.Connection connection, AtmosphereConfig config) {
        this.connection = connection;
        this.config = config;
    }

    @Override
    public void writeError(int errorCode, String message) throws IOException {
        if (!this.firstWrite.get()) {
            logger.debug("The WebSocket handshake succeeded but the dispatched URI failed {}:{}. The WebSocket connection is still open and client can continue sending messages.", (Object)message, (Object)errorCode);
        } else {
            logger.debug("{} {}", (Object)errorCode, (Object)message);
        }
    }

    @Override
    public void redirect(String location) throws IOException {
        logger.error("WebSocket Redirect not supported");
    }

    @Override
    public void write(String data) throws IOException {
        this.firstWrite.set(true);
        if (!this.connection.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        this.connection.sendMessage(data);
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.firstWrite.set(true);
        if (!this.connection.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        String s = this.config.getInitParameter("org.atmosphere.websocket.supportBlob");
        if (s != null && Boolean.parseBoolean(s)) {
            this.connection.sendMessage(data, 0, data.length);
        } else {
            this.connection.sendMessage(new String(data, 0, data.length, "UTF-8"));
        }
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        this.firstWrite.set(true);
        if (!this.connection.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        String s = this.config.getInitParameter("org.atmosphere.websocket.supportBlob");
        if (s != null && Boolean.parseBoolean(s)) {
            this.connection.sendMessage(data, offset, length);
        } else {
            this.connection.sendMessage(new String(data, offset, length, "UTF-8"));
        }
    }

    @Override
    public void close() throws IOException {
        logger.trace("WebSocket.close()");
        this.connection.disconnect();
    }

    @Override
    public void flush() throws IOException {
    }

    public String toString() {
        return this.connection.toString();
    }
}

