/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyCometSupport
extends AsynchronousProcessor {
    public static final String SUSPEND = NettyCometSupport.class.getName() + ".suspend";
    public static final String RESUME = NettyCometSupport.class.getName() + ".resume";
    public static final String CHANNEL = NettyCometSupport.class.getName() + ".channel";
    private static final Logger logger = LoggerFactory.getLogger(NettyCometSupport.class);

    public NettyCometSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereFramework.Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        AtmosphereFramework.Action action = null;
        action = this.suspended(req, res);
        if (action.type == AtmosphereFramework.Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)res);
            req.setAttribute(SUSPEND, action);
            req.setAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK, new AsynchronousProcessor.AsynchronousProcessorHook((AtmosphereResourceImpl)req.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE)));
        } else if (action.type == AtmosphereFramework.Action.TYPE.RESUME) {
            req.setAttribute(SUSPEND, action);
            Boolean resumeOnBroadcast = (Boolean)req.getAttribute("org.atmosphere.resumeOnBroadcast");
            if (resumeOnBroadcast != null && resumeOnBroadcast.booleanValue()) {
                return action;
            }
            logger.debug("Resuming response: {}", (Object)res);
            AtmosphereFramework.Action nextAction = this.resumed(req, res);
            if (nextAction.type == AtmosphereFramework.Action.TYPE.SUSPEND) {
                logger.debug("Suspending after resuming response: {}", (Object)res);
                req.setAttribute(SUSPEND, action);
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        super.action(r);
        if (r.isResumed() && r.getRequest().getAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK) != null) {
            if (r.getRequest().getAttribute(CHANNEL) == null) {
                return;
            }
            try {
                ((AsyncIOWriter)r.getRequest().getAttribute(CHANNEL)).close();
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
        }
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

