/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.JettyWebSocketHandler;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketUtil {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocketUtil.class);

    public static final AtmosphereFramework.Action doService(AsynchronousProcessor cometSupport, AtmosphereRequest req, AtmosphereResponse res, WebSocketFactory webSocketFactory) throws IOException, ServletException {
        Boolean b;
        boolean webSocketEnabled = false;
        if (req.getHeaders("Connection") != null && req.getHeaders("Connection").hasMoreElements()) {
            String[] e;
            for (String upgrade : e = req.getHeaders("Connection").nextElement().toString().split(",")) {
                if (!upgrade.trim().equalsIgnoreCase("Upgrade")) continue;
                webSocketEnabled = true;
                break;
            }
        }
        if ((b = (Boolean)req.getAttribute(WebSocket.WEBSOCKET_INITIATED)) == null) {
            b = Boolean.FALSE;
        }
        if (!webSocketEnabled) {
            return null;
        }
        if (webSocketFactory != null && !b.booleanValue()) {
            req.setAttribute(WebSocket.WEBSOCKET_INITIATED, true);
            webSocketFactory.acceptWebSocket((HttpServletRequest)req, (HttpServletResponse)res);
            return new AtmosphereFramework.Action();
        }
        AtmosphereFramework.Action action = cometSupport.suspended(req, res);
        if (action.type == AtmosphereFramework.Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)res);
        } else if (action.type == AtmosphereFramework.Action.TYPE.RESUME) {
            logger.debug("Resume response: {}", (Object)res);
            req.setAttribute(WebSocket.WEBSOCKET_RESUME, true);
        }
        return action;
    }

    public static final WebSocketFactory getFactory(final AtmosphereConfig config) {
        WebSocketFactory webSocketFactory = new WebSocketFactory(new WebSocketFactory.Acceptor(){

            public boolean checkOrigin(HttpServletRequest request, String origin) {
                logger.debug("WebSocket-checkOrigin request {} with origin {}", (Object)request.getRequestURI(), (Object)origin);
                return true;
            }

            public org.eclipse.jetty.websocket.WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
                logger.debug("WebSocket-connect request {} with protocol {}", (Object)request.getRequestURI(), (Object)protocol);
                return new JettyWebSocketHandler(AtmosphereRequest.wrap(request), config.framework(), config.framework().getWebSocketProtocol());
            }
        });
        int bufferSize = 8192;
        if (config.getInitParameter("org.atmosphere.websocket.bufferSize") != null) {
            bufferSize = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.bufferSize"));
        }
        logger.info("WebSocket Buffer side {}", (Object)bufferSize);
        webSocketFactory.setBufferSize(bufferSize);
        int timeOut = 300000;
        if (config.getInitParameter("org.atmosphere.websocket.maxIdleTime") != null) {
            timeOut = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.maxIdleTime"));
        }
        logger.info("WebSocket idle timeout {}", (Object)timeOut);
        webSocketFactory.setMaxIdleTime(timeOut);
        int maxTextBufferSize = 8192;
        if (config.getInitParameter("org.atmosphere.websocket.maxTextMessageSize") != null) {
            maxTextBufferSize = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.maxTextMessageSize"));
        }
        logger.info("WebSocket maxTextBufferSize {}", (Object)maxTextBufferSize);
        webSocketFactory.setMaxTextMessageSize(maxTextBufferSize);
        int maxBinaryBufferSize = 8192;
        if (config.getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize") != null) {
            maxBinaryBufferSize = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize"));
        }
        logger.info("WebSocket maxBinaryBufferSize {}", (Object)maxBinaryBufferSize);
        webSocketFactory.setMaxBinaryMessageSize(maxBinaryBufferSize);
        return webSocketFactory;
    }
}

