/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.DefaultWebSocket;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketEngine;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.container.version.GrizzlyWebSocket;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlassFishWebSocketSupport
extends GrizzlyCometSupport {
    private static final Logger logger = LoggerFactory.getLogger(GlassFishWebSocketSupport.class);
    private GrizzlyApplication application;

    public GlassFishWebSocketSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.application = new GrizzlyApplication(this.config);
        WebSocketEngine.getEngine().register((WebSocketApplication)this.application);
    }

    @Override
    public void shutdown() {
        WebSocketEngine.getEngine().unregister((WebSocketApplication)this.application);
        super.shutdown();
    }

    @Override
    public AtmosphereFramework.Action service(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        boolean webSocketEnabled = false;
        if (request.getHeaders("Connection") != null && request.getHeaders("Connection").hasMoreElements()) {
            String[] e;
            for (String upgrade : e = request.getHeaders("Connection").nextElement().toString().split(",")) {
                if (!upgrade.equalsIgnoreCase("Upgrade")) continue;
                webSocketEnabled = true;
                break;
            }
        }
        if (!webSocketEnabled) {
            return super.service(request, response);
        }
        AtmosphereFramework.Action action = this.suspended(request, response);
        if (action.type == AtmosphereFramework.Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)response);
        } else if (action.type == AtmosphereFramework.Action.TYPE.RESUME) {
            logger.debug("Resuming response: {}", (Object)response);
        }
        return action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    private static final class GrizzlyApplication
    extends WebSocketApplication {
        private final AtmosphereConfig config;
        private WebSocketProcessor webSocketProcessor;

        public GrizzlyApplication(AtmosphereConfig config) {
            this.config = config;
        }

        public void onConnect(WebSocket w) {
            super.onConnect(w);
            if (!DefaultWebSocket.class.isAssignableFrom(w.getClass())) {
                throw new IllegalStateException();
            }
            DefaultWebSocket webSocket = (DefaultWebSocket)DefaultWebSocket.class.cast(w);
            try {
                this.webSocketProcessor = new WebSocketProcessor(this.config.framework(), new GrizzlyWebSocket((WebSocket)webSocket), this.config.framework().getWebSocketProtocol());
                this.webSocketProcessor.dispatch(AtmosphereRequest.wrap(webSocket.getRequest()));
            }
            catch (Exception e) {
                logger.warn("failed to connect to web socket", (Throwable)e);
            }
        }

        public boolean isApplicationRequest(Request request) {
            return true;
        }

        public void onClose(WebSocket w, DataFrame df) {
            super.onClose(w, df);
            logger.debug("onClose {} ", (Object)w);
            this.webSocketProcessor.close(1000);
        }

        public void onMessage(WebSocket w, String text) {
            logger.debug("onMessage {} ", (Object)w);
            this.webSocketProcessor.invokeWebSocketProtocol(text);
        }

        public void onMessage(WebSocket w, byte[] bytes) {
            logger.debug("onMessage (bytes) {} ", (Object)w);
            this.webSocketProcessor.invokeWebSocketProtocol(bytes, 0, bytes.length);
        }

        public void onPing(WebSocket w, byte[] bytes) {
            logger.debug("onPing (bytes) {} ", (Object)w);
        }

        public void onPong(WebSocket w, byte[] bytes) {
            logger.debug("onPong (bytes) {} ", (Object)w);
        }

        public void onFragment(WebSocket w, byte[] bytes, boolean last) {
            logger.debug("onFragment (bytes) {} ", (Object)w);
        }

        public void onFragment(WebSocket w, String text, boolean last) {
            logger.debug("onFragment (string) {} ", (Object)w);
        }
    }
}

