/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.lang.reflect.Field;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.tomcat.util.http.mapper.MappingData;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tomcat7CometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Tomcat7CometSupport.class);
    public static final String COMET_EVENT = "CometEvent";
    private static final String SUSPENDED = Tomcat7CometSupport.class.getName() + ".suspended";
    private final Boolean closeConnectionOnInputStream;
    private static final IllegalStateException unableToDetectComet = new IllegalStateException(Tomcat7CometSupport.unableToDetectComet());

    public Tomcat7CometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
        String b = config.getInitParameter(ApplicationConfig.TOMCAT_CLOSE_STREAM);
        this.closeConnectionOnInputStream = b == null ? true : Boolean.parseBoolean(b.toString());
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CometEvent event = (CometEvent)req.getAttribute(COMET_EVENT);
        if (event == null) {
            throw unableToDetectComet;
        }
        AtmosphereServlet.Action action = null;
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            action = this.suspended(req, res);
            if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                logger.debug("Suspending response: {}", (Object)res);
                try {
                    if (action.timeout != -1L) {
                        event.setTimeout((int)action.timeout);
                    } else {
                        event.setTimeout(Integer.MAX_VALUE);
                    }
                    req.setAttribute(SUSPENDED, (Object)true);
                }
                catch (UnsupportedOperationException ex) {}
            } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
                logger.debug("Resuming response: {}", (Object)res);
                this.bz51881(event);
            } else {
                this.bz51881(event);
            }
        } else if (event.getEventType() != CometEvent.EventType.READ) {
            if (event.getEventSubType() == CometEvent.EventSubType.CLIENT_DISCONNECT) {
                logger.debug("Client closed connection: response: {}", (Object)res);
                if (req.getAttribute(SUSPENDED) != null) {
                    req.setAttribute(SUSPENDED, null);
                    action = this.cancelled(req, res);
                } else {
                    logger.debug("Cancelling response: {}", (Object)res);
                }
                this.bz51881(event);
            } else if (event.getEventSubType() == CometEvent.EventSubType.TIMEOUT) {
                logger.debug("Timing out response: {}", (Object)res);
                action = this.timedout(req, res);
                this.bz51881(event);
            } else if (event.getEventType() == CometEvent.EventType.ERROR) {
                this.bz51881(event);
            } else if (event.getEventType() == CometEvent.EventType.END) {
                if (req.getAttribute(SUSPENDED) != null && this.closeConnectionOnInputStream.booleanValue()) {
                    req.setAttribute(SUSPENDED, null);
                    action = this.cancelled(req, res);
                } else {
                    logger.debug("Cancelling response: {}", (Object)res);
                    this.bz51881(event);
                }
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bz51881(CometEvent event) throws IOException {
        String[] tomcatVersion = this.config.getServletContext().getServerInfo().substring(14).split("\\.");
        String minorVersion = tomcatVersion[2];
        if (minorVersion.indexOf("-") != -1 && Integer.valueOf(minorVersion = minorVersion.substring(0, minorVersion.indexOf("-"))) == 22) {
            minorVersion = "23";
        }
        if (Integer.valueOf(tomcatVersion[0]) == 7 && Integer.valueOf(minorVersion) < 23) {
            Request r;
            logger.info("Patching Tomcat 7.0.22 and lower bz51881. Expect NPE inside CoyoteAdapter, just ignore them. Upgrade to 7.0.23");
            try {
                RequestFacade request = (RequestFacade)RequestFacade.class.cast(event.getHttpServletRequest());
                Field coyoteRequest = RequestFacade.class.getDeclaredField("request");
                coyoteRequest.setAccessible(true);
                r = (Request)coyoteRequest.get(request);
                r.recycle();
                Field mappingData = Request.class.getDeclaredField("mappingData");
                mappingData.setAccessible(true);
                MappingData m = new MappingData();
                m.context = null;
                mappingData.set(r, m);
            }
            catch (Throwable t) {
                logger.trace("Was unable to recycle internal Tomcat object");
            }
            finally {
                try {
                    event.close();
                }
                catch (IllegalStateException e) {
                    logger.trace("", (Throwable)e);
                }
            }
            try {
                ResponseFacade response = (ResponseFacade)ResponseFacade.class.cast(event.getHttpServletResponse());
                Field coyoteResponse = ResponseFacade.class.getDeclaredField("response");
                coyoteResponse.setAccessible(true);
                r = (Response)coyoteResponse.get(response);
                r.recycle();
            }
            catch (Throwable t) {
                logger.trace("Was unable to recycle internal Tomcat object");
            }
        } else {
            event.close();
        }
    }

    @Override
    public void action(AtmosphereResourceImpl resource) {
        super.action(resource);
        if (resource.action().type == AtmosphereServlet.Action.TYPE.RESUME && resource.isInScope()) {
            try {
                CometEvent event = (CometEvent)resource.getRequest().getAttribute(COMET_EVENT);
                if (event == null) {
                    return;
                }
                if (this.config.getInitParameter(ApplicationConfig.RESUME_AND_KEEPALIVE) == null || this.config.getInitParameter(ApplicationConfig.RESUME_AND_KEEPALIVE).equalsIgnoreCase("false")) {
                    this.bz51881(event);
                }
            }
            catch (IOException ex) {
                logger.debug("action failed", (Throwable)ex);
            }
        }
    }

    @Override
    public AtmosphereServlet.Action cancelled(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = super.cancelled(req, res);
        if (req.getAttribute(ApplicationConfig.MAX_INACTIVE) != null && (Long)Long.class.cast(req.getAttribute(ApplicationConfig.MAX_INACTIVE)) == -1L) {
            CometEvent event = (CometEvent)req.getAttribute(COMET_EVENT);
            if (event == null) {
                return action;
            }
            this.bz51881(event);
        }
        return action;
    }

    private static String unableToDetectComet() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tomcat failed to detect this is a Comet application because context.xml ");
        sb.append("is missing or the Http11NioProtocol Connector is not enabled.");
        sb.append("\nIf that's not the case, you can also remove META-INF/context.xml and WEB-INF/lib/atmosphere-compat-tomcat.jar");
        return sb.toString();
    }
}

