/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import java.io.IOException;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.websocket.WebSocketAdapter;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty8WebSocket
extends WebSocketAdapter {
    private static final Logger logger = LoggerFactory.getLogger(Jetty8WebSocket.class);
    private final WebSocket.Connection connection;
    private final AtmosphereServlet.AtmosphereConfig config;

    public Jetty8WebSocket(WebSocket.Connection connection, AtmosphereServlet.AtmosphereConfig config) {
        this.connection = connection;
        this.config = config;
    }

    @Override
    public void writeError(int errorCode, String message) throws IOException {
        logger.debug("{} {}", (Object)errorCode, (Object)message);
    }

    @Override
    public void redirect(String location) throws IOException {
        logger.error("redirect not supported");
    }

    @Override
    public void write(String data) throws IOException {
        if (!this.connection.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        this.connection.sendMessage(data);
    }

    @Override
    public void write(byte[] data) throws IOException {
        if (!this.connection.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        String s = this.config.getInitParameter("org.atmosphere.websocket.supportBlob");
        if (s != null && Boolean.parseBoolean(s)) {
            this.connection.sendMessage(data, 0, data.length);
        } else {
            this.connection.sendMessage(new String(data, 0, data.length, "UTF-8"));
        }
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (!this.connection.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        String s = this.config.getInitParameter("org.atmosphere.websocket.supportBlob");
        if (s != null && Boolean.parseBoolean(s)) {
            this.connection.sendMessage(data, offset, length);
        } else {
            this.connection.sendMessage(new String(data, offset, length, "UTF-8"));
        }
    }

    @Override
    public void close() throws IOException {
        logger.trace("WebSocket.close()");
        this.connection.disconnect();
    }
}

