/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.protocol;

import java.io.Serializable;
import java.util.HashMap;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpProtocol
implements WebSocketProtocol,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(SimpleHttpProtocol.class);
    private String contentType;
    private String methodType;
    private String delimiter;

    @Override
    public void configure(AtmosphereServlet.AtmosphereConfig config) {
        String contentType = config.getInitParameter("org.atmosphere.websocket.messageContentType");
        if (contentType == null) {
            contentType = "text/html";
        }
        this.contentType = contentType;
        String methodType = config.getInitParameter("org.atmosphere.websocket.messageMethod");
        if (methodType == null) {
            methodType = "POST";
        }
        this.methodType = methodType;
        String delimiter = config.getInitParameter("org.atmosphere.websocket.pathDelimiter");
        if (delimiter == null) {
            delimiter = "@@";
        }
        this.delimiter = delimiter;
    }

    @Override
    public AtmosphereRequest onMessage(WebSocket webSocket, String d) {
        AtmosphereResourceImpl resource = (AtmosphereResourceImpl)webSocket.resource();
        if (resource == null) {
            logger.error("Invalid state. No AtmosphereResource has been suspended");
            return null;
        }
        String pathInfo = resource.getRequest().getPathInfo();
        if (d.startsWith(this.delimiter)) {
            String[] token = d.split(this.delimiter);
            pathInfo = token[1];
            d = token[2];
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("websocket-subprotocol", "polling-websocket-message");
        return new AtmosphereRequest.Builder().request(resource.getRequest()).method(this.methodType).contentType(this.contentType).body(d).attributes(m).pathInfo(pathInfo).headers(WebSocketProcessor.configureHeader(resource.getRequest())).build();
    }

    @Override
    public AtmosphereRequest onMessage(WebSocket webSocket, byte[] d, int offset, int length) {
        return this.onMessage(webSocket, new String(d, offset, length));
    }

    @Override
    public void onOpen(WebSocket webSocket) {
    }

    @Override
    public void onClose(WebSocket webSocket) {
    }

    @Override
    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException t) {
        logger.warn(t.getMessage() + " Status {} Message {}", (Object)t.response().getStatus(), (Object)t.response().getStatusMessage());
    }

    @Override
    public boolean inspectResponse() {
        return false;
    }

    @Override
    public String handleResponse(AtmosphereResponse<?> res, String message) {
        return message;
    }

    @Override
    public byte[] handleResponse(AtmosphereResponse<?> res, byte[] message, int offset, int length) {
        return message;
    }
}

