/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.Meteor;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketAdapter;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketProcessor
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketProcessor.class);
    private final AtmosphereServlet atmosphereServlet;
    private final WebSocket webSocket;
    private final WebSocketProtocol webSocketProtocol;
    private final AtomicBoolean loggedMsg = new AtomicBoolean(false);

    public WebSocketProcessor(AtmosphereServlet atmosphereServlet, WebSocket webSocket, WebSocketProtocol webSocketProtocol) {
        this.webSocket = webSocket;
        this.atmosphereServlet = atmosphereServlet;
        this.webSocketProtocol = webSocketProtocol;
    }

    public final void dispatch(HttpServletRequest request) throws IOException {
        if (!this.loggedMsg.getAndSet(true)) {
            logger.debug("Atmosphere detected WebSocket: {}", (Object)this.webSocket.getClass().getName());
        }
        String pathInfo = request.getPathInfo();
        String requestURI = request.getRequestURI();
        if (this.atmosphereServlet.getAtmosphereConfig().getWebServerName().toLowerCase().indexOf("glassfish") != -1) {
            try {
                pathInfo = pathInfo.substring(pathInfo.indexOf("/", 1));
                requestURI = requestURI.substring(requestURI.indexOf("/", 1));
            }
            catch (IndexOutOfBoundsException e) {
                logger.warn("Unable to patch GlassFish WebSocket http://java.net/jira/browse/GRIZZLY-1114");
            }
        }
        AtmosphereResponse<WebSocket> wsr = new AtmosphereResponse<WebSocket>(this.webSocket, this.webSocketProtocol, request);
        AtmosphereRequest r = new AtmosphereRequest.Builder().request(request).pathInfo(pathInfo).requestURI(requestURI).headers(WebSocketProcessor.configureHeader(request)).build();
        request.setAttribute(WebSocket.WEBSOCKET_SUSPEND, (Object)true);
        this.dispatch((HttpServletRequest)r, wsr);
        this.webSocketProtocol.onOpen(this.webSocket);
        if (!this.webSocket.resource().getAtmosphereResourceEvent().isSuspended()) {
            this.webSocketProtocol.onError(this.webSocket, new WebSocketException("No AtmosphereResource has been suspended. The WebSocket will be closed.", wsr));
        }
    }

    public void invokeWebSocketProtocol(String webSocketMessage) {
        AtmosphereRequest r = this.webSocketProtocol.onMessage(this.webSocket, webSocketMessage);
        if (r != null) {
            AtmosphereResponse<WebSocket> w = new AtmosphereResponse<WebSocket>(this.webSocket, this.webSocketProtocol, (HttpServletRequest)r);
            this.dispatch((HttpServletRequest)r, w);
        }
    }

    public void invokeWebSocketProtocol(byte[] data, int offset, int length) {
        AtmosphereRequest r = this.webSocketProtocol.onMessage(this.webSocket, data, offset, length);
        if (r != null) {
            AtmosphereResponse<WebSocket> w = new AtmosphereResponse<WebSocket>(this.webSocket, this.webSocketProtocol, (HttpServletRequest)r);
            this.dispatch((HttpServletRequest)r, w);
        }
    }

    protected final void dispatch(HttpServletRequest request, AtmosphereResponse<?> r) {
        if (request == null) {
            return;
        }
        try {
            this.atmosphereServlet.doCometSupport(request, (HttpServletResponse)r);
        }
        catch (IOException e) {
            logger.warn("Failed invoking atmosphere servlet doCometSupport()", (Throwable)e);
        }
        catch (ServletException e) {
            logger.warn("Failed invoking atmosphere servlet doCometSupport()", (Throwable)e);
        }
        AtmosphereResource resource = (AtmosphereResource)request.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        if (this.webSocket.resource() == null && WebSocketAdapter.class.isAssignableFrom(this.webSocket.getClass())) {
            ((WebSocketAdapter)WebSocketAdapter.class.cast(this.webSocket)).setAtmosphereResource(resource);
        }
        if (r.getStatus() >= 400) {
            this.webSocketProtocol.onError(this.webSocket, new WebSocketException("Status code higher than 400", r));
        }
    }

    public WebSocket webSocket() {
        return this.webSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block11: {
            AtmosphereResource<?, ?> resource = this.webSocket.resource();
            try {
                this.webSocketProtocol.onClose(this.webSocket);
                if (resource == null) break block11;
                AtmosphereHandler handler = (AtmosphereHandler)((HttpServletRequest)resource.getRequest()).getAttribute(FrameworkConfig.ATMOSPHERE_HANDLER);
                AtmosphereResource<?, ?> atmosphereResource = resource;
                synchronized (atmosphereResource) {
                    Meteor m;
                    if (handler != null) {
                        handler.onStateChange(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)resource, false, true));
                    }
                    if ((m = (Meteor)((HttpServletRequest)resource.getRequest()).getAttribute(AtmosphereResourceImpl.METEOR)) != null) {
                        m.destroy();
                    }
                }
                try {
                    resource.notifyListeners();
                }
                finally {
                    AsynchronousProcessor.destroyResource(resource);
                }
            }
            catch (IOException e) {
                if (resource != null && AtmosphereResourceImpl.class.isAssignableFrom(resource.getClass())) {
                    ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(resource)).onThrowable(e);
                }
                logger.warn("Failed invoking atmosphere handler onStateChange()", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "WebSocketProcessor{ webSocket=" + this.webSocket + " }";
    }

    public void notifyListener(WebSocketEventListener.WebSocketEvent event) {
        AtmosphereResource<?, ?> resource = this.webSocket.resource();
        if (resource == null) {
            return;
        }
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(resource);
        for (AtmosphereResourceEventListener l : r.atmosphereResourceEventListener()) {
            if (!WebSocketEventListener.class.isAssignableFrom(l.getClass())) continue;
            try {
                switch (event.type()) {
                    case CONNECT: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onConnect(event);
                        break;
                    }
                    case DISCONNECT: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onDisconnect(event);
                        break;
                    }
                    case CONTROL: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onControl(event);
                        break;
                    }
                    case MESSAGE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onMessage(event);
                        break;
                    }
                    case HANDSHAKE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onHandshake(event);
                        break;
                    }
                    case CLOSE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onClose(event);
                    }
                }
            }
            catch (Throwable t) {
                logger.debug("Listener error {}", t);
                try {
                    ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onThrowable(new AtmosphereResourceEventImpl(r, false, false, t));
                }
                catch (Throwable t2) {
                    logger.warn("Listener error {}", t2);
                }
            }
        }
    }

    public static final Map<String, String> configureHeader(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            headers.put(s, request.getParameter(s));
        }
        headers.put("X-Atmosphere-Transport", "websocket");
        return headers;
    }

    public static final class WebSocketException
    extends Exception {
        private final AtmosphereResponse r;

        public WebSocketException(String s, AtmosphereResponse r) {
            super(s);
            this.r = r;
        }

        public WebSocketException(Throwable throwable, AtmosphereResponse r) {
            super(throwable);
            this.r = r;
        }

        public AtmosphereResponse response() {
            return this.r;
        }
    }
}

