/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.atmosphere.websocket.container.Jetty8WebSocket;
import org.atmosphere.websocket.container.JettyWebSocket;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketHandler
implements WebSocket,
WebSocket.OnFrame,
WebSocket.OnBinaryMessage,
WebSocket.OnTextMessage,
WebSocket.OnControl {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocketHandler.class);
    private WebSocketProcessor webSocketProcessor;
    private final HttpServletRequest request;
    private final AtmosphereServlet atmosphereServlet;
    private WebSocketProtocol webSocketProtocol;

    public JettyWebSocketHandler(HttpServletRequest request, AtmosphereServlet atmosphereServlet, String webSocketProtocolClassName) {
        this.request = new JettyRequestFix(request, request.getServletPath(), request.getContextPath(), request.getPathInfo(), request.getRequestURI());
        this.atmosphereServlet = atmosphereServlet;
        try {
            this.webSocketProtocol = (WebSocketProtocol)JettyWebSocketHandler.class.getClassLoader().loadClass(webSocketProtocolClassName).newInstance();
            this.webSocketProtocol.configure(atmosphereServlet.getAtmosphereConfig());
        }
        catch (Exception ex) {
            logger.error("Cannot load the WebSocketProtocol {}", (Object)webSocketProtocolClassName, (Object)ex);
        }
    }

    public void onConnect(WebSocket.Outbound outbound) {
        logger.debug("WebSocket.onConnect (outbound)");
        try {
            this.webSocketProcessor = new WebSocketProcessor(this.atmosphereServlet, new JettyWebSocket(outbound), this.webSocketProtocol);
            this.webSocketProcessor.dispatch(this.request);
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    public void onMessage(byte frame, String data) {
        logger.trace("WebSocket.onMessage (frame/string)");
        this.webSocketProcessor.invokeWebSocketProtocol(data);
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(data, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
    }

    public void onMessage(byte frame, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onMessage (frame)");
        this.webSocketProcessor.invokeWebSocketProtocol(new String(data, offset, length));
        try {
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
    }

    public void onFragment(boolean more, byte opcode, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onFragment");
        this.webSocketProcessor.invokeWebSocketProtocol(new String(data, offset, length));
        try {
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
    }

    public void onDisconnect() {
        logger.trace("WebSocket.onDisconnect");
        this.webSocketProcessor.close();
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.DISCONNECT, this.webSocketProcessor.webSocket()));
    }

    public void onMessage(byte[] data, int offset, int length) {
        logger.trace("WebSocket.onMessage (bytes)");
        this.webSocketProcessor.invokeWebSocketProtocol(data, offset, length);
        try {
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
    }

    public boolean onControl(byte controlCode, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onControl.");
        this.webSocketProcessor.invokeWebSocketProtocol(data, offset, length);
        try {
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(new String(data, offset, length, "UTF-8"), WebSocketEventListener.WebSocketEvent.TYPE.CONTROL, this.webSocketProcessor.webSocket()));
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("UnsupportedEncodingException", (Throwable)e);
        }
        return false;
    }

    public boolean onFrame(byte flags, byte opcode, byte[] data, int offset, int length) {
        logger.trace("WebSocket.onFrame.");
        return false;
    }

    public void onHandshake(WebSocket.FrameConnection connection) {
        logger.trace("WebSocket.onHandshake");
        try {
            this.webSocketProcessor = new WebSocketProcessor(this.atmosphereServlet, new Jetty8WebSocket((WebSocket.Connection)connection), this.webSocketProtocol);
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.HANDSHAKE, this.webSocketProcessor.webSocket()));
    }

    public void onMessage(String data) {
        logger.trace("WebSocket.onMessage");
        this.webSocketProcessor.invokeWebSocketProtocol(data);
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent(data, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, this.webSocketProcessor.webSocket()));
    }

    public void onOpen(WebSocket.Connection connection) {
        logger.trace("WebSocket.onOpen.");
        try {
            this.webSocketProcessor = new WebSocketProcessor(this.atmosphereServlet, new Jetty8WebSocket(connection), this.webSocketProtocol);
            this.webSocketProcessor.dispatch(this.request);
            this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.CONNECT, this.webSocketProcessor.webSocket()));
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    public void onClose(int closeCode, String message) {
        logger.trace("WebSocket.OnClose.");
        this.webSocketProcessor.notifyListener(new WebSocketEventListener.WebSocketEvent("", WebSocketEventListener.WebSocketEvent.TYPE.CLOSE, this.webSocketProcessor.webSocket()));
        AtmosphereResource r = (AtmosphereResource)this.request.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
        if (r != null) {
            r.getBroadcaster().removeAtmosphereResource(r);
        }
        this.webSocketProcessor.close();
    }

    private static class JettyRequestFix
    extends HttpServletRequestWrapper {
        private final String contextPath;
        private final String servletPath;
        private final String pathInfo;
        private final String requestUri;

        public JettyRequestFix(HttpServletRequest request, String servletPath, String contextPath, String pathInfo, String requestUri) {
            super(request);
            this.servletPath = servletPath;
            this.contextPath = contextPath;
            this.pathInfo = pathInfo;
            this.requestUri = requestUri;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getRequestURI() {
            return this.requestUri;
        }
    }
}

