/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.LinkedList;
import java.util.List;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.container.GlassFishWebSocketSupport;
import org.atmosphere.container.GlassFishv2CometSupport;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.container.JBossWebCometSupport;
import org.atmosphere.container.Jetty7CometSupport;
import org.atmosphere.container.JettyCometSupport;
import org.atmosphere.container.JettyCometSupportWithWebSocket;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.container.Servlet30CometSupportWithWebSocket;
import org.atmosphere.container.Tomcat7CometSupport;
import org.atmosphere.container.TomcatCometSupport;
import org.atmosphere.container.WebLogicCometSupport;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.CometSupportResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCometSupportResolver
implements CometSupportResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCometSupportResolver.class);
    public static final String SERVLET_30 = "javax.servlet.AsyncListener";
    public static final String GLASSFISH_V2 = "com.sun.enterprise.web.PEWebContainer";
    public static final String TOMCAT_7 = "org.apache.catalina.comet.CometFilterChain";
    public static final String TOMCAT = "org.apache.coyote.http11.Http11NioProcessor";
    public static final String JBOSS_5 = "org.jboss.";
    public static final String JETTY = "org.mortbay.util.ajax.Continuation";
    public static final String JETTY_7 = "org.eclipse.jetty.servlet.ServletContextHandler";
    public static final String JETTY_8 = "org.eclipse.jetty.continuation.Servlet3Continuation";
    public static final String GRIZZLY = "com.sun.grizzly.http.servlet.ServletAdapter";
    public static final String WEBLOGIC = "weblogic.servlet.http.FutureResponseModel";
    public static final String JBOSSWEB = "org.apache.catalina.connector.HttpEventImpl";
    public static final String GRIZZLY_WEBSOCKET = "com.sun.grizzly.websockets.WebSocketEngine";
    private final AtmosphereServlet.AtmosphereConfig config;

    public DefaultCometSupportResolver(AtmosphereServlet.AtmosphereConfig config) {
        this.config = config;
    }

    protected boolean testClassExists(String testClass) {
        try {
            return testClass != null && testClass.length() > 0 && Thread.currentThread().getContextClassLoader().loadClass(testClass) != null;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        catch (NoClassDefFoundError ex) {
            return false;
        }
    }

    public List<Class<? extends CometSupport>> detectContainersPresent() {
        return new LinkedList<Class<? extends CometSupport>>(){
            {
                if (DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.GLASSFISH_V2)) {
                    this.add(GlassFishv2CometSupport.class);
                }
                if (DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.JETTY)) {
                    this.add(JettyCometSupport.class);
                }
                if (DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.JETTY_7)) {
                    this.add(Jetty7CometSupport.class);
                }
                if (DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.JETTY_8)) {
                    this.add(Jetty7CometSupport.class);
                }
                if (DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.JBOSSWEB)) {
                    this.add(JBossWebCometSupport.class);
                }
                if (DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.TOMCAT_7)) {
                    this.add(Tomcat7CometSupport.class);
                }
                if (DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.TOMCAT) || DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.JBOSS_5)) {
                    this.add(TomcatCometSupport.class);
                }
                if (DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.GRIZZLY)) {
                    this.add(GrizzlyCometSupport.class);
                }
                if (DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.WEBLOGIC)) {
                    this.add(WebLogicCometSupport.class);
                }
            }
        };
    }

    public List<Class<? extends CometSupport>> detectWebSocketPresent() {
        LinkedList<Class<? extends CometSupport>> l = new LinkedList<Class<? extends CometSupport>>(){
            {
                if (DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.TOMCAT)) {
                    logger.info("Tomcat doesn't support WebSocket. Ignoring web.xml config init-param");
                } else {
                    if (DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.JETTY_8)) {
                        this.add(JettyCometSupportWithWebSocket.class);
                    }
                    if (DefaultCometSupportResolver.this.testClassExists(DefaultCometSupportResolver.GRIZZLY_WEBSOCKET)) {
                        this.add(GlassFishWebSocketSupport.class);
                    }
                }
            }
        };
        if (l.isEmpty()) {
            return this.detectContainersPresent();
        }
        return l;
    }

    public CometSupport defaultCometSupport(boolean preferBlocking) {
        if (!preferBlocking && this.testClassExists(SERVLET_30)) {
            if (this.detectWebSocketPresent().size() > 0) {
                return new Servlet30CometSupportWithWebSocket(this.config);
            }
            return new Servlet30CometSupport(this.config);
        }
        return new BlockingIOCometSupport(this.config);
    }

    public CometSupport newCometSupport(Class<? extends CometSupport> targetClass) {
        try {
            return targetClass.getDeclaredConstructor(AtmosphereServlet.AtmosphereConfig.class).newInstance(this.config);
        }
        catch (Exception e) {
            logger.error("failed to create comet support class: {}, error: {}", targetClass, (Object)e.getMessage());
            throw new IllegalArgumentException("Comet support class " + targetClass.getCanonicalName() + " has bad signature.", e);
        }
    }

    public CometSupport newCometSupport(String targetClassFQN) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return (CometSupport)cl.loadClass(targetClassFQN).getDeclaredConstructor(AtmosphereServlet.AtmosphereConfig.class).newInstance(this.config);
        }
        catch (Exception e) {
            logger.error("failed to create comet support class: {}, error: {}", (Object)targetClassFQN, (Object)e.getMessage());
            throw new IllegalArgumentException("Comet support class " + targetClassFQN + " has bad signature.", e);
        }
    }

    public CometSupport resolve(boolean useNativeIfPossible, boolean defaultToBlocking) {
        CometSupport servletAsyncSupport = this.defaultCometSupport(defaultToBlocking);
        if (!defaultToBlocking && (useNativeIfPossible || servletAsyncSupport.getClass().getName().equals(BlockingIOCometSupport.class.getName()))) {
            CometSupport nativeSupport = this.resolveNativeCometSupport(this.detectContainersPresent());
            return nativeSupport == null ? servletAsyncSupport : nativeSupport;
        }
        return servletAsyncSupport;
    }

    @Override
    public CometSupport resolve(boolean useNativeIfPossible, boolean defaultToBlocking, boolean useWebsocketIfPossible) {
        CometSupport cs = !useWebsocketIfPossible ? this.resolve(useNativeIfPossible, defaultToBlocking) : this.resolveWebSocket(this.detectWebSocketPresent());
        if (cs == null) {
            return new BlockingIOCometSupport(this.config);
        }
        return cs;
    }

    public CometSupport resolveWebSocket(List<Class<? extends CometSupport>> available) {
        if (available == null || available.isEmpty()) {
            return null;
        }
        return this.newCometSupport(available.get(0));
    }

    protected CometSupport resolveNativeCometSupport(List<Class<? extends CometSupport>> available) {
        if (available == null || available.isEmpty()) {
            return null;
        }
        if (available.size() == 1) {
            return this.newCometSupport(available.get(0));
        }
        return this.resolveMultipleNativeSupportConflict(available);
    }

    protected CometSupport resolveMultipleNativeSupportConflict(List<Class<? extends CometSupport>> available) {
        StringBuilder b = new StringBuilder("Found multiple containers, please specify which one to use: ");
        for (Class<? extends CometSupport> cs : available) {
            b.append(cs != null ? cs.getCanonicalName() : "null").append(", ");
        }
        b.append(" until you do, Atmosphere will use:" + available.get(0));
        logger.warn("{}", (Object)b.toString());
        return this.newCometSupport(available.get(0));
    }
}

