/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.websockets.BaseServerWebSocket;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketEngine;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlassFishWebSocketSupport
extends GrizzlyCometSupport {
    private static final Logger logger = LoggerFactory.getLogger(GlassFishWebSocketSupport.class);

    public GlassFishWebSocketSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        WebSocketEngine.getEngine().register(sc.getServletContext().getContextPath(), (WebSocketApplication)new GrizzlyApplication());
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean webSocketEnabled = false;
        if (request.getHeaders("Connection") != null && request.getHeaders("Connection").hasMoreElements()) {
            String[] e;
            for (String upgrade : e = ((String)request.getHeaders("Connection").nextElement()).split(",")) {
                if (!upgrade.equalsIgnoreCase("Upgrade")) continue;
                webSocketEnabled = true;
                break;
            }
        }
        if (!webSocketEnabled) {
            return super.service(request, response);
        }
        AtmosphereServlet.Action action = this.suspended(request, response);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)response);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            logger.debug("Resuming response: {}", (Object)response);
        }
        return action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    public class GrizzlyWebSocket
    implements WebSocket {
        private final com.sun.grizzly.websockets.WebSocket webSocket;

        public GrizzlyWebSocket(com.sun.grizzly.websockets.WebSocket webSocket) {
            this.webSocket = webSocket;
        }

        @Override
        public void writeError(int errorCode, String message) throws IOException {
        }

        @Override
        public void redirect(String location) throws IOException {
        }

        @Override
        public void write(byte frame, String data) throws IOException {
            this.webSocket.send(data);
        }

        @Override
        public void write(byte frame, byte[] data) throws IOException {
            this.webSocket.send(new String(data));
        }

        @Override
        public void write(byte frame, byte[] data, int offset, int length) throws IOException {
            this.webSocket.send(new String(data, offset, length));
        }

        @Override
        public void close() throws IOException {
            this.webSocket.close();
        }
    }

    public class GrizzlyApplication
    extends WebSocketApplication {
        private WebSocketProcessor webSocketProcessor;

        public void onConnect(com.sun.grizzly.websockets.WebSocket w) {
            if (!BaseServerWebSocket.class.isAssignableFrom(w.getClass())) {
                throw new IllegalStateException();
            }
            BaseServerWebSocket webSocket = (BaseServerWebSocket)BaseServerWebSocket.class.cast(w);
            try {
                this.webSocketProcessor = (WebSocketProcessor)GrizzlyWebSocket.class.getClassLoader().loadClass(GlassFishWebSocketSupport.this.config.getServlet().getWebSocketProcessorClassName()).getDeclaredConstructor(AtmosphereServlet.class, WebSocket.class).newInstance(GlassFishWebSocketSupport.this.config.getServlet(), new GrizzlyWebSocket((com.sun.grizzly.websockets.WebSocket)webSocket));
                this.webSocketProcessor.dispatch((HttpServletRequest)new HttpServletRequestWrapper(webSocket.getRequest()));
            }
            catch (Exception e) {
                logger.warn("failed to connect to web socket", (Throwable)e);
            }
        }

        public boolean isApplicationRequest(Request request) {
            return true;
        }

        public void onMessage(com.sun.grizzly.websockets.WebSocket webSocket, DataFrame dataFrame) {
            this.webSocketProcessor.parseMessage(dataFrame.getTextPayload());
        }

        public void onClose(com.sun.grizzly.websockets.WebSocket webSocket) {
            this.webSocketProcessor.close();
        }
    }
}

