/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcludeSessionBroadcaster
extends DefaultBroadcaster {
    private static final Logger logger = LoggerFactory.getLogger(ExcludeSessionBroadcaster.class);

    public ExcludeSessionBroadcaster() {
        this.setID(ExcludeSessionBroadcaster.class.getSimpleName());
    }

    public ExcludeSessionBroadcaster(String id) {
        super(id);
    }

    @Override
    public <T> Future<T> broadcast(T msg, AtmosphereResource<?, ?> r) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        HashSet sub = new HashSet();
        sub.addAll(this.resources);
        sub.remove(r);
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        this.messages.offer((DefaultBroadcaster)this.new DefaultBroadcaster.Entry(newMsg, sub, f, msg));
        return f;
    }

    @Override
    public <T> Future<T> broadcast(T msg, Set<AtmosphereResource<?, ?>> subset) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        subset.retainAll(this.resources);
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        this.messages.offer((DefaultBroadcaster)this.new DefaultBroadcaster.Entry(newMsg, subset, f, msg));
        return f;
    }

    public <T> Future<T> broadcast(T msg, List<HttpSession> sessions) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        HashSet subset = new HashSet();
        subset.addAll(this.resources);
        for (AtmosphereResource r : this.resources) {
            if (r.getAtmosphereResourceEvent().isCancelled() || !sessions.contains(((HttpServletRequest)r.getRequest()).getSession())) continue;
            subset.remove(r);
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        this.messages.offer((DefaultBroadcaster)this.new DefaultBroadcaster.Entry(newMsg, subset, f, msg));
        return f;
    }

    public <T> Future<T> broadcast(T msg, HttpSession s) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("This Broadcaster has been destroyed and cannot be used");
        }
        HashSet subset = new HashSet();
        subset.addAll(this.resources);
        for (AtmosphereResource r : this.resources) {
            if (r.getAtmosphereResourceEvent().isCancelled() || !s.equals(((HttpServletRequest)r.getRequest()).getSession())) continue;
            subset.remove(r);
        }
        this.start();
        Object newMsg = this.filter(msg);
        if (newMsg == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(newMsg);
        this.messages.offer((DefaultBroadcaster)this.new DefaultBroadcaster.Entry(newMsg, subset, f, msg));
        return f;
    }
}

