/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketHttpServletResponse;
import org.atmosphere.websocket.WebSocketSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletRequestWebSocketProcessor
extends WebSocketProcessor
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereServlet.class);
    private final String contentType;
    private final String methodType;

    public HttpServletRequestWebSocketProcessor(AtmosphereServlet atmosphereServlet, WebSocketSupport webSocketSupport) {
        super(atmosphereServlet, webSocketSupport);
        String contentType = atmosphereServlet.config.getInitParameter("org.atmosphere.cpr.webSocket.messageContentType");
        if (contentType == null) {
            contentType = "text/html";
        }
        this.contentType = contentType;
        String methodType = atmosphereServlet.config.getInitParameter("org.atmosphere.cpr.webSocket.messageMethod");
        if (methodType == null) {
            methodType = "POST";
        }
        this.methodType = methodType;
    }

    @Override
    public void broadcast(final String data) {
        try {
            this.atmosphereServlet().doCometSupport((HttpServletRequest)new HttpServletRequestWrapper(this.request()){
                private ByteInputStream bis;
                private BufferedReader br;
                {
                    super(x0);
                    this.bis = new ByteInputStream(data.getBytes(), 0, data.getBytes().length);
                    this.br = new BufferedReader(new StringReader(data));
                }

                public String getMethod() {
                    return HttpServletRequestWebSocketProcessor.this.methodType;
                }

                public String getContentType() {
                    return HttpServletRequestWebSocketProcessor.this.contentType;
                }

                public Enumeration getHeaders(String name) {
                    ArrayList list = Collections.list(super.getHeaders(name));
                    if (name.equalsIgnoreCase("content-type")) {
                        list.add(HttpServletRequestWebSocketProcessor.this.contentType);
                    }
                    if (list.size() == 0 && name.startsWith("X-Atmosphere") && HttpServletRequestWebSocketProcessor.this.request().getAttribute(name) != null) {
                        list.add(HttpServletRequestWebSocketProcessor.this.request().getAttribute(name));
                    }
                    return Collections.enumeration(list);
                }

                public Enumeration<String> getHeaderNames() {
                    ArrayList list = Collections.list(super.getHeaderNames());
                    list.add("content-type");
                    Enumeration e = HttpServletRequestWebSocketProcessor.this.request().getAttributeNames();
                    while (e.hasMoreElements()) {
                        String name = e.nextElement().toString();
                        if (!name.startsWith("X-Atmosphere")) continue;
                        list.add(name);
                    }
                    return Collections.enumeration(list);
                }

                public String getHeader(String s) {
                    if (s.equalsIgnoreCase("Connection")) {
                        return "keep-alive";
                    }
                    if ("content-type".equalsIgnoreCase(s)) {
                        return HttpServletRequestWebSocketProcessor.this.contentType;
                    }
                    String name = super.getHeader(s);
                    if (name != null && name.startsWith("X-Atmosphere")) {
                        return (String)HttpServletRequestWebSocketProcessor.this.request().getAttribute(s);
                    }
                    return name;
                }

                public ServletInputStream getInputStream() throws IOException {
                    return this.bis;
                }

                public BufferedReader getReader() throws IOException {
                    return this.br;
                }
            }, (HttpServletResponse)new WebSocketHttpServletResponse<WebSocketSupport>(this.webSocketSupport()));
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (ServletException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void broadcast(final byte[] data, final int offset, final int length) {
        try {
            this.atmosphereServlet().doCometSupport((HttpServletRequest)new HttpServletRequestWrapper(this.request()){
                private ByteInputStream bis;
                private BufferedReader br;
                {
                    super(x0);
                    this.bis = new ByteInputStream(data, offset, length);
                    this.br = new BufferedReader(new StringReader(new String(data, "UTF-8")));
                }

                public String getMethod() {
                    return HttpServletRequestWebSocketProcessor.this.methodType;
                }

                public String getContentType() {
                    return HttpServletRequestWebSocketProcessor.this.contentType;
                }

                public Enumeration getHeaders(String name) {
                    ArrayList list = Collections.list(super.getHeaders(name));
                    if (name.equalsIgnoreCase("content-type")) {
                        list.add(HttpServletRequestWebSocketProcessor.this.contentType);
                    }
                    if (list.size() == 0 && name.startsWith("X-Atmosphere") && HttpServletRequestWebSocketProcessor.this.request().getAttribute(name) != null) {
                        list.add(HttpServletRequestWebSocketProcessor.this.request().getAttribute(name));
                    }
                    return Collections.enumeration(list);
                }

                public Enumeration<String> getHeaderNames() {
                    ArrayList list = Collections.list(super.getHeaderNames());
                    list.add("content-type");
                    Enumeration e = HttpServletRequestWebSocketProcessor.this.request().getAttributeNames();
                    while (e.hasMoreElements()) {
                        String name = e.nextElement().toString();
                        if (!name.startsWith("X-Atmosphere")) continue;
                        list.add(name);
                    }
                    return Collections.enumeration(list);
                }

                public String getHeader(String s) {
                    if (s.equalsIgnoreCase("Connection")) {
                        return "keep-alive";
                    }
                    if ("content-type".equalsIgnoreCase(s)) {
                        return HttpServletRequestWebSocketProcessor.this.contentType;
                    }
                    String name = super.getHeader(s);
                    if (name != null && name.startsWith("X-Atmosphere")) {
                        return (String)HttpServletRequestWebSocketProcessor.this.request().getAttribute(s);
                    }
                    return name;
                }

                public ServletInputStream getInputStream() throws IOException {
                    return this.bis;
                }

                public BufferedReader getReader() throws IOException {
                    return this.br;
                }
            }, (HttpServletResponse)new WebSocketHttpServletResponse<WebSocketSupport>(this.webSocketSupport()));
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (ServletException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static class ByteInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream bis;

        public ByteInputStream(byte[] data, int offset, int length) {
            this.bis = new ByteArrayInputStream(data, offset, length);
        }

        public int read() throws IOException {
            return this.bis.read();
        }
    }
}

