/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterLifeCyclePolicy;
import org.atmosphere.di.InjectorProvider;
import org.atmosphere.util.AbstractBroadcasterProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBroadcasterFactory
extends BroadcasterFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBroadcasterFactory.class);
    private final ConcurrentHashMap<Object, Broadcaster> store = new ConcurrentHashMap();
    private final Class<? extends Broadcaster> clazz;
    private BroadcasterLifeCyclePolicy policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER).build();

    protected DefaultBroadcasterFactory(Class<? extends Broadcaster> clazz, String broadcasterLifeCyclePolicy) {
        this.clazz = clazz;
        if (factory == null) {
            factory = this;
        }
        this.configure(broadcasterLifeCyclePolicy);
    }

    private void configure(String broadcasterLifeCyclePolicy) {
        if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE).idleTimeInMS(30000).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_DESTROY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_DESTROY).idleTimeInMS(30000).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER).build();
        } else {
            logger.warn("Unsupported BroadcasterLifeCyclePolicy policy {}", (Object)broadcasterLifeCyclePolicy);
        }
    }

    @Override
    public final synchronized Broadcaster get() throws IllegalAccessException, InstantiationException {
        Broadcaster b = this.clazz.newInstance();
        InjectorProvider.getInjector().inject(b);
        if (AbstractBroadcasterProxy.class.isAssignableFrom(b.getClass())) {
            ((AbstractBroadcasterProxy)AbstractBroadcasterProxy.class.cast(b)).configure(config);
        }
        b.setBroadcasterConfig(new BroadcasterConfig(AtmosphereServlet.broadcasterFilters, config));
        b.setID(this.clazz.getSimpleName() + "-" + UUID.randomUUID());
        b.setBroadcasterLifeCyclePolicy(this.policy);
        this.store.put(b.getID(), b);
        return b;
    }

    @Override
    public final synchronized Broadcaster get(Class<? extends Broadcaster> c, Object id) throws IllegalAccessException, InstantiationException {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (c == null) {
            throw new NullPointerException("Class is null");
        }
        if (this.getBroadcaster(id) != null) {
            throw new IllegalStateException("Broadcaster already existing. Use BroadcasterFactory.lookup instead");
        }
        Broadcaster b = c.newInstance();
        InjectorProvider.getInjector().inject(b);
        if (AbstractBroadcasterProxy.class.isAssignableFrom(b.getClass())) {
            ((AbstractBroadcasterProxy)AbstractBroadcasterProxy.class.cast(b)).configure(config);
        }
        b.setBroadcasterConfig(new BroadcasterConfig(AtmosphereServlet.broadcasterFilters, config));
        b.setID(id.toString());
        b.setBroadcasterLifeCyclePolicy(this.policy);
        this.store.put(id, b);
        return b;
    }

    private Broadcaster getBroadcaster(Object name) {
        return this.store.get(name);
    }

    @Override
    public boolean add(Broadcaster b, Object id) {
        return this.store.put(id, b) == null;
    }

    @Override
    public boolean remove(Broadcaster b, Object id) {
        return this.store.remove(id) != null;
    }

    @Override
    public final Broadcaster lookup(Class<? extends Broadcaster> c, Object id) {
        return this.lookup(c, id, false);
    }

    @Override
    public Broadcaster lookup(Class<? extends Broadcaster> c, Object id, boolean createIfNull) {
        Broadcaster b = this.getBroadcaster(id);
        if (b != null && !c.isAssignableFrom(b.getClass())) {
            String msg = "Invalid lookup class " + c.getName() + ". Cached class is: " + b.getClass().getName();
            logger.debug("{}", (Object)msg);
            throw new IllegalStateException(msg);
        }
        if (b == null && createIfNull) {
            try {
                b = this.get(c, id);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllAtmosphereResource(AtmosphereResource<?, ?> r) {
        try {
            AtmosphereResource<?, ?> atmosphereResource = r;
            synchronized (atmosphereResource) {
                if (this.store.size() > 0) {
                    for (Broadcaster b : this.lookupAll()) {
                        try {
                            b.removeAtmosphereResource(r);
                        }
                        catch (IllegalStateException ex) {
                            logger.trace(ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public Collection<Broadcaster> lookupAll() {
        return Collections.unmodifiableCollection(this.store.values());
    }

    @Override
    public synchronized void destroy() {
        Enumeration<Broadcaster> e = this.store.elements();
        while (e.hasMoreElements()) {
            e.nextElement().destroy();
        }
        this.store.clear();
        factory = null;
    }

    public static BroadcasterFactory buildAndReplaceDefaultfactory(Class<? extends Broadcaster> clazz, AtmosphereServlet.AtmosphereConfig c) throws InstantiationException, IllegalAccessException {
        factory = new DefaultBroadcasterFactory(clazz, "NEVER");
        config = c;
        return factory;
    }
}

