/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;

public class WebLogicCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(WebLogicCometSupport.class);
    public static final String RRK = "RequestResponseKey";

    public WebLogicCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = this.suspended(req, res);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)res);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            logger.debug("Resuming response: {}", (Object)res);
            AtmosphereServlet.Action nextAction = this.resumed(req, res);
            if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                logger.debug("Suspending after resuming response: {}", (Object)res);
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        super.action(actionEvent);
        if (actionEvent.isInScope() && actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME && (this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE) == null || this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE).equalsIgnoreCase("false"))) {
            try {
                RequestResponseKey rrk = (RequestResponseKey)actionEvent.getRequest().getSession().getAttribute(RRK);
                AbstractAsyncServlet.notify((RequestResponseKey)rrk, null);
            }
            catch (IOException ex) {
                logger.debug("action failed", (Throwable)ex);
            }
        }
    }
}

