/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.websockets.BaseServerWebSocket;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketEngine;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlassFishWebSocketSupport
extends GrizzlyCometSupport {
    private static final Logger logger = LoggerFactory.getLogger(GlassFishWebSocketSupport.class);

    public GlassFishWebSocketSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        WebSocketEngine.getEngine().register(sc.getServletContext().getContextPath(), (WebSocketApplication)new GrizzlyApplication());
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String connection = request.getHeader("Connection");
        if (!"Upgrade".equalsIgnoreCase(connection)) {
            return super.service(request, response);
        }
        AtmosphereServlet.Action action = this.suspended(request, response);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)response);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            logger.debug("Resuming response: {}", (Object)response);
        }
        return action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    public class GrizzlyWebSocketSupport
    implements WebSocketSupport {
        private final WebSocket webSocket;

        public GrizzlyWebSocketSupport(WebSocket webSocket) {
            this.webSocket = webSocket;
        }

        @Override
        public void writeError(int errorCode, String message) throws IOException {
        }

        @Override
        public void redirect(String location) throws IOException {
        }

        @Override
        public void write(byte frame, String data) throws IOException {
            this.webSocket.send(data);
        }

        @Override
        public void write(byte frame, byte[] data) throws IOException {
            this.webSocket.send(new String(data));
        }

        @Override
        public void write(byte frame, byte[] data, int offset, int length) throws IOException {
            this.webSocket.send(new String(data, offset, length));
        }

        @Override
        public void close() throws IOException {
            this.webSocket.close();
        }
    }

    public class GrizzlyApplication
    extends WebSocketApplication {
        private WebSocketProcessor webSocketProcessor;

        public void onConnect(WebSocket w) {
            if (!BaseServerWebSocket.class.isAssignableFrom(w.getClass())) {
                throw new IllegalStateException();
            }
            BaseServerWebSocket webSocket = (BaseServerWebSocket)BaseServerWebSocket.class.cast(w);
            this.webSocketProcessor = new WebSocketProcessor(GlassFishWebSocketSupport.this.config.getServlet(), new GrizzlyWebSocketSupport((WebSocket)webSocket));
            try {
                this.webSocketProcessor.connect((HttpServletRequest)new HttpServletRequestWrapper(webSocket.getRequest()));
            }
            catch (IOException e) {
                logger.warn("failed to connect to web socket", (Throwable)e);
            }
        }

        public boolean isApplicationRequest(Request request) {
            return true;
        }

        public void onMessage(WebSocket webSocket, DataFrame dataFrame) {
            this.webSocketProcessor.broadcast((byte)0, dataFrame.getTextPayload());
        }

        public void onClose(WebSocket webSocket) {
            this.webSocketProcessor.close();
        }
    }
}

