/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.IOException;
import org.atmosphere.websocket.WebSocketSupport;
import org.eclipse.jetty.websocket.WebSocket;

public class JettyWebSocketSupport
implements WebSocketSupport {
    private final WebSocket.Outbound outbound;

    public JettyWebSocketSupport(WebSocket.Outbound outbound) {
        this.outbound = outbound;
    }

    @Override
    public void writeError(int errorCode, String message) throws IOException {
    }

    @Override
    public void redirect(String location) throws IOException {
    }

    @Override
    public void write(byte frame, String data) throws IOException {
        if (!this.outbound.isOpen()) {
            throw new IOException("Connection closed");
        }
        this.outbound.sendMessage(frame, data);
    }

    @Override
    public void write(byte frame, byte[] data) throws IOException {
        if (!this.outbound.isOpen()) {
            throw new IOException("Connection closed");
        }
        this.outbound.sendMessage(frame, data, 0, data.length);
    }

    @Override
    public void write(byte frame, byte[] data, int offset, int length) throws IOException {
        if (!this.outbound.isOpen()) {
            throw new IOException("Connection closed");
        }
        this.outbound.sendMessage(frame, data, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.outbound.disconnect();
    }
}

