/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.websocket.WebSocketSupport;

public class Servlet30Support
extends AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    public Servlet30Support(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public String getContainerName() {
        return super.getContainerName() + " using javax.servlet/3.0";
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = this.suspended(req, res);
        if (req.getAttribute(WebSocketSupport.WEBSOCKET_SUSPEND) == null) {
            if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Suspending" + res);
                }
                this.suspend(action, req, res);
            } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
                AsyncContext asyncContext;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Resuming" + res);
                }
                if (this.supportSession() && (asyncContext = (AsyncContext)req.getSession().getAttribute("org.atmosphere.container.asyncContext")) != null) {
                    asyncContext.complete();
                }
                AtmosphereServlet.Action nextAction = this.resumed(req, res);
                if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND && this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Suspending after Resuming" + res);
                    this.suspend(action, req, res);
                }
            }
        } else if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending " + res);
            }
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Resume " + res);
            }
            req.setAttribute(WebSocketSupport.WEBSOCKET_RESUME, (Object)"true");
        }
        return action;
    }

    private void suspend(AtmosphereServlet.Action action, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (!req.isAsyncStarted()) {
            AsyncContext asyncContext = req.startAsync();
            asyncContext.addListener((AsyncListener)new CometListener());
            if (action.timeout != -1L) {
                asyncContext.setTimeout(action.timeout);
            } else {
                asyncContext.setTimeout(Integer.MAX_VALUE);
            }
            req.setAttribute("org.atmosphere.container.asyncContext", (Object)asyncContext);
            if (this.supportSession()) {
                req.getSession().setAttribute("org.atmosphere.container.asyncContext", (Object)asyncContext);
            }
        }
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME && actionEvent.isInScope()) {
            AsyncContext asyncContext = (AsyncContext)actionEvent.getRequest().getAttribute("org.atmosphere.container.asyncContext");
            if (asyncContext == null && this.supportSession()) {
                asyncContext = (AsyncContext)actionEvent.getRequest().getSession().getAttribute("org.atmosphere.container.asyncContext");
            }
            if (asyncContext != null && (this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE) == null || this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE).equalsIgnoreCase("false"))) {
                asyncContext.complete();
            }
        } else if (!actionEvent.isInScope() && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Already resumed or cancelled " + actionEvent);
        }
    }

    private class CometListener
    implements AsyncListener {
        private CometListener() {
        }

        public void onComplete(AsyncEvent event) throws IOException {
            if (Servlet30Support.this.logger.isLoggable(Level.FINE)) {
                Servlet30Support.this.logger.fine("Resumed (completed)" + event.getAsyncContext().getRequest());
            }
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            block3: {
                if (Servlet30Support.this.logger.isLoggable(Level.FINE)) {
                    Servlet30Support.this.logger.fine("onTimeout" + event.getAsyncContext().getRequest());
                }
                try {
                    Servlet30Support.this.timedout((HttpServletRequest)event.getAsyncContext().getRequest(), (HttpServletResponse)event.getAsyncContext().getResponse());
                }
                catch (ServletException ex) {
                    if (!Servlet30Support.this.logger.isLoggable(Level.FINE)) break block3;
                    Servlet30Support.this.logger.log(Level.FINE, "onTimeout" + event.getAsyncContext().getResponse(), ex);
                }
            }
        }

        public void onError(AsyncEvent event) {
            block3: {
                if (Servlet30Support.this.logger.isLoggable(Level.FINE)) {
                    Servlet30Support.this.logger.log(Level.FINE, "onError" + event.getAsyncContext().getResponse());
                }
                try {
                    Servlet30Support.this.cancelled((HttpServletRequest)event.getAsyncContext().getRequest(), (HttpServletResponse)event.getAsyncContext().getResponse());
                }
                catch (Throwable ex) {
                    if (!Servlet30Support.this.logger.isLoggable(Level.FINE)) break block3;
                    Servlet30Support.this.logger.log(Level.FINE, "cancelled" + event.getAsyncContext().getResponse(), ex);
                }
            }
        }

        public void onStartAsync(AsyncEvent event) {
            if (Servlet30Support.this.logger.isLoggable(Level.FINE)) {
                Servlet30Support.this.logger.log(Level.FINE, "onStartAsync" + event.getAsyncContext().getResponse());
            }
        }
    }
}

